/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.profile;

import jakarta.inject.Inject;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.profile.ProfileDisplayService;
import org.squashtest.tm.service.internal.display.dto.PermissionsDto;
import org.squashtest.tm.service.internal.display.dto.ProfileActivePermissionsRecord;
import org.squashtest.tm.service.internal.display.dto.ProfileAdminViewDto;
import org.squashtest.tm.service.profile.ProfileManagerService;
import org.squashtest.tm.web.backend.controller.profile.ProfileViewController;

@RestController
@RequestMapping(value={"/backend/profile-view"})
public class ProfileViewController {
    private final ProfileDisplayService profileDisplayService;
    private final ProfileManagerService profileManagerService;

    @Inject
    ProfileViewController(ProfileDisplayService profileDisplayService, ProfileManagerService profileManagerService) {
        this.profileDisplayService = profileDisplayService;
        this.profileManagerService = profileManagerService;
    }

    @GetMapping(value={"/{profileId}"})
    public ProfileAdminViewDto getProfileView(@PathVariable long profileId) {
        return this.profileDisplayService.getProfileView(profileId);
    }

    @PostMapping(value={"/{profileId}/deactivate"})
    public void deactivateProfile(@PathVariable long profileId) {
        this.profileManagerService.deactivateProfile(profileId);
    }

    @PostMapping(value={"/{profileId}/activate"})
    public void activateProfile(@PathVariable long profileId) {
        this.profileManagerService.activateProfile(profileId);
    }

    @PostMapping(value={"/{profileId}/description"})
    public void changeDescription(@PathVariable long profileId, @RequestBody ProfileRecord record) {
        this.profileManagerService.changeDescription(profileId, record.description);
    }

    @PostMapping(value={"/{profileId}/name"})
    public void changeName(@PathVariable long profileId, @RequestBody ProfileRecord record) {
        this.profileManagerService.changeName(profileId, record.name);
    }

    @PostMapping(value={"/{profileId}/permissions"})
    public void changePermissions(@PathVariable long profileId, @RequestBody List<ProfileActivePermissionsRecord> records) {
        this.profileManagerService.changePermissions(profileId, records);
    }

    @GetMapping(value={"/{profileId}/permissions"})
    public List<PermissionsDto> getPermissions(@PathVariable long profileId) {
        return this.profileDisplayService.getPermissions(profileId);
    }
}

