/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.orchestrator;

import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.internal.dto.WorkflowDto;
import org.squashtest.tm.service.orchestrator.OrchestratorOperationService;
import org.squashtest.tm.service.orchestrator.model.OrchestratorConfVersions;
import org.squashtest.tm.service.orchestrator.model.OrchestratorResponse;
import org.squashtest.tm.web.backend.controller.orchestrator.OrchestratorOperationController;

@RestController
@RequestMapping(value={"/backend/orchestrator-operation/{testAutomationServerId}/"})
public class OrchestratorOperationController {
    private final OrchestratorOperationService orchestratorOperationService;

    public OrchestratorOperationController(OrchestratorOperationService orchestratorOperationService) {
        this.orchestratorOperationService = orchestratorOperationService;
    }

    @GetMapping(value={"/orchestrator-configuration"})
    public OrchestratorResponse<OrchestratorConfVersions> getOrchestratorConfiguration(@PathVariable Long testAutomationServerId) {
        return this.orchestratorOperationService.getOrchestratorConfVersions(testAutomationServerId);
    }

    @GetMapping(value={"/project/{projectId}/workflows"})
    public OrchestratorResponse<List<WorkflowDto>> getProjectWorkflows(@PathVariable Long projectId, @PathVariable Long testAutomationServerId) {
        return this.orchestratorOperationService.getProjectWorkflows(testAutomationServerId, projectId);
    }

    @PostMapping(value={"/project/{projectId}/kill-workflow"})
    public OrchestratorResponse<Void> killWorkflow(@PathVariable Long projectId, @PathVariable Long testAutomationServerId, @RequestBody WorkflowPatch patch) {
        return this.orchestratorOperationService.killWorkflow(testAutomationServerId, projectId, patch.workflowId);
    }
}

