/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.issue;

import java.util.Locale;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.service.internal.display.dto.IssuesPanelModel;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.remoteissue.RemoteIssueDisplayService;
import org.squashtest.tm.web.backend.controller.issue.RemoteKnownIssuesDisplayController;

@RestController
@RequestMapping(value={"/backend/issues"})
public class RemoteKnownIssuesDisplayController {
    private final GenericProjectManagerService projectManager;
    private final RemoteIssueDisplayService remoteIssueDisplayService;

    public RemoteKnownIssuesDisplayController(GenericProjectManagerService projectManager, RemoteIssueDisplayService remoteIssueDisplayService) {
        this.projectManager = projectManager;
        this.remoteIssueDisplayService = remoteIssueDisplayService;
    }

    @GetMapping(value={"project/{projectId}"})
    public IssuesPanelModel getIssuePanel(@PathVariable Long projectId, Locale locale) {
        GenericProject project = this.projectManager.findById(projectId.longValue());
        if (project.isBoundToBugtracker()) {
            return this.remoteIssueDisplayService.getIssuesPanelModel(project, locale);
        }
        return new IssuesPanelModel();
    }

    @PostMapping(value={"{entityType}/{entityId}/known-issues"})
    public GridResponse getKnownIssueData(@PathVariable String entityType, @PathVariable long entityId, @RequestBody GridRequest gridRequest) {
        IssueDisplaySorting sorter = new IssueDisplaySorting(gridRequest);
        return this.remoteIssueDisplayService.buildKnownIssuesGrid(entityType, entityId, (PagingAndSorting)sorter, gridRequest);
    }

    @PostMapping(value={"{entityType}/{entityId}/all-known-issues"})
    public GridResponse getKnownIssuesDataWithoutPaging(@PathVariable String entityType, @PathVariable Long entityId) {
        return this.remoteIssueDisplayService.buildAllKnownIssuesGrid(entityType, entityId.longValue());
    }
}

