/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.issue;

import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.PropertyEditor;
import java.util.List;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.csp.core.bugtracker.domain.BTIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchForm;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.BugTrackerBindingInfo;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.service.attachment.UploadedData;
import org.squashtest.tm.service.bugtracker.BugTrackerManagerService;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.bugtracker.BugTrackersService;
import org.squashtest.tm.service.internal.configuration.CallbackUrlProvider;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.remoteissue.RemoteIssueReportService;
import org.squashtest.tm.service.testautomation.spi.BadConfiguration;
import org.squashtest.tm.web.backend.controller.attachment.UploadedDataPropertyEditorSupport;
import org.squashtest.tm.web.backend.controller.bugtracker.BugTrackerControllerHelper;
import org.squashtest.tm.web.backend.controller.issue.RemoteIssueReportController;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import oslcdomain.OslcIssue;

@RestController
@RequestMapping(value={"/backend/issues"})
public class RemoteIssueReportController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteIssueReportController.class);
    private final BugTrackersLocalService bugTrackersLocalService;
    private final BugTrackersService bugTrackersService;
    private final BugTrackerManagerService bugTrackerManagerService;
    private final InternationalizationHelper messageSource;
    private final GenericProjectManagerService projectManager;
    private final CallbackUrlProvider callbackUrlProvider;
    private final RemoteIssueReportService remoteIssueReportService;

    @Inject
    RemoteIssueReportController(BugTrackersLocalService bugTrackersLocalService, BugTrackerManagerService bugTrackerManagerService, InternationalizationHelper messageSource, BugTrackersService bugTrackersService, GenericProjectManagerService projectManager, CallbackUrlProvider callbackUrlProvider, RemoteIssueReportService remoteIssueReportService) {
        this.bugTrackersLocalService = bugTrackersLocalService;
        this.bugTrackerManagerService = bugTrackerManagerService;
        this.messageSource = messageSource;
        this.bugTrackersService = bugTrackersService;
        this.projectManager = projectManager;
        this.callbackUrlProvider = callbackUrlProvider;
        this.remoteIssueReportService = remoteIssueReportService;
    }

    @InitBinder
    public void initBinder(ServletRequestDataBinder binder) {
        binder.registerCustomEditor(UploadedData.class, (PropertyEditor)new UploadedDataPropertyEditorSupport());
    }

    @GetMapping(value={"{entityType}/{entityId}/new-issue"})
    public RemoteIssue getEntityReportStub(@PathVariable String entityType, @PathVariable Long entityId, @RequestParam(value="project-name") String projectName, HttpServletRequest request) {
        return this.remoteIssueReportService.makeManualIssueHolderReportIssueModel(entityType, entityId.longValue(), projectName, this.getSquashPublicUrl(request), (MessageSource)this.messageSource);
    }

    @PostMapping(value={"{entityType}/{entityId}/new-issue"})
    public Map<String, String> postEntityIssueReport(@PathVariable String entityType, @PathVariable Long entityId, @RequestBody BTIssue jsonIssue) {
        return this.remoteIssueReportService.postManualIssueHolderIssueReport(entityType, entityId.longValue(), (RemoteIssue)jsonIssue);
    }

    @PostMapping(value={"{entityType}/{entityId}/new-advanced-issue"})
    public Map<String, String> postEntityAdvancedIssueReport(@PathVariable String entityType, @PathVariable Long entityId, @RequestBody AdvancedIssue jsonAdvancedIssue) {
        return this.remoteIssueReportService.postManualIssueHolderIssueReport(entityType, entityId.longValue(), (RemoteIssue)jsonAdvancedIssue);
    }

    @PostMapping(value={"{entityType}/{entityId}/new-oslc-issue"})
    public void postEntityOslcIssueReport(@PathVariable String entityType, @PathVariable Long entityId, @RequestBody NewOslcIssueRequestBody jsonOslc) {
        OslcIssue oslcIssue = new OslcIssue();
        oslcIssue.setId(jsonOslc.issueId);
        this.remoteIssueReportService.postManualIssueHolderIssueReport(entityType, entityId.longValue(), (RemoteIssue)oslcIssue);
    }

    @PostMapping(value={"/issue-search-form"})
    public RemoteIssueSearchForm getIssueSearchForm(@RequestBody GetIssueSearchFormRequestBody requestBody) {
        BugTracker bugTracker = this.bugTrackerManagerService.findById(requestBody.bugTrackerId.longValue());
        GenericProject project = this.projectManager.findById(requestBody.projectId.longValue());
        BugTrackerBindingInfo bugTrackerBindingInfo = this.bugTrackersService.getBugTrackerBindingInfo(project);
        return this.bugTrackersService.getRemoteIssueSearchForm(bugTracker, bugTrackerBindingInfo);
    }

    @PostMapping(value={"/search-issue"})
    public RemoteIssue findIssue(@RequestBody FindIssueRequestBody requestBody) {
        BugTracker bugTracker = this.bugTrackerManagerService.findById(requestBody.bugTrackerId.longValue());
        return this.bugTrackersLocalService.searchIssue(requestBody.toSearchRequest(), bugTracker).orElse(null);
    }

    @DeleteMapping(value={"/{issueIds}"})
    public void detachIssues(@PathVariable List<Long> issueIds) {
        this.bugTrackersLocalService.detachIssues(issueIds);
    }

    @PostMapping(value={"/{btName}/{remoteIssueId}/attachments"})
    public void forwardAttachmentsToIssue(@PathVariable String btName, @PathVariable String remoteIssueId, @RequestParam(value="attachment[]") List<UploadedData> uploads) {
        this.remoteIssueReportService.forwardAttachmentsToIssue(btName, remoteIssueId, uploads);
    }

    @PostMapping(value={"{bugtrackerName}/command"})
    public Object forwardDelegateCommand(@PathVariable String bugtrackerName, @RequestBody DelegateCommand command) {
        return this.bugTrackersLocalService.forwardDelegateCommand(command, bugtrackerName);
    }

    private String getSquashPublicUrl(HttpServletRequest request) {
        try {
            return this.callbackUrlProvider.getCallbackUrl().toExternalForm();
        }
        catch (BadConfiguration badConfigurationException) {
            LOGGER.debug("Could not get squash public url.", (Throwable)badConfigurationException);
            return BugTrackerControllerHelper.extractBaseUrl((HttpServletRequest)request);
        }
    }
}

