/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.infolist;

import jakarta.inject.Inject;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.infolist.InfoListDisplayService;
import org.squashtest.tm.service.infolist.InfoListItemManagerService;
import org.squashtest.tm.service.infolist.InfoListManagerService;
import org.squashtest.tm.service.internal.display.dto.InfoListAdminViewDto;
import org.squashtest.tm.web.backend.controller.infolist.InfoListItemController;

@RestController
@RequestMapping(value={"/backend/info-list-items"})
public class InfoListItemController {
    InfoListItemManagerService infoListItemManagerService;
    InfoListManagerService infoListManagerService;
    InfoListDisplayService infoListDisplayService;

    @Inject
    InfoListItemController(InfoListItemManagerService infoListItemManagerService, InfoListManagerService infoListManagerService, InfoListDisplayService infoListDisplayService) {
        this.infoListItemManagerService = infoListItemManagerService;
        this.infoListManagerService = infoListManagerService;
        this.infoListDisplayService = infoListDisplayService;
    }

    @PostMapping(value={"/{infoListItemId}/label"})
    public void changeLabel(@PathVariable long infoListItemId, @RequestBody InfoListItemPatch patch) {
        this.infoListItemManagerService.changeLabel(infoListItemId, patch.getLabel());
    }

    @PostMapping(value={"/{infoListItemId}/code"})
    public void changeCode(@PathVariable long infoListItemId, @RequestBody InfoListItemPatch patch) {
        this.infoListItemManagerService.changeCode(infoListItemId, patch.getCode());
    }

    @PostMapping(value={"/{infoListItemId}/colour"})
    public void changeColour(@PathVariable long infoListItemId, @RequestBody InfoListItemPatch patch) {
        this.infoListItemManagerService.changeColour(infoListItemId, patch.getColour());
    }

    @PostMapping(value={"/{infoListItemId}/default"})
    public void setDefault(@PathVariable long infoListItemId) {
        this.infoListItemManagerService.changeDefault(infoListItemId);
    }

    @PostMapping(value={"/{infoListItemId}/icon-name"})
    public void changeIcon(@PathVariable long infoListItemId, @RequestBody InfoListItemPatch patch) {
        this.infoListItemManagerService.changeIcon(infoListItemId, patch.getIconName());
    }

    @DeleteMapping(value={"/{infoListId}/items/{infoListItemIds}"})
    public void deleteInfoListItem(@PathVariable long infoListId, @PathVariable List<Long> infoListItemIds) {
        this.infoListItemManagerService.removeInfoListItems(infoListItemIds, infoListId);
    }

    @PostMapping(value={"/{infoListId}/items/positions"})
    public InfoListAdminViewDto changeOptionsPositions(@PathVariable long infoListId, @RequestBody ReorderOptionsRequestBody requestBody) {
        this.infoListManagerService.changeItemsPositions(infoListId, requestBody.getPosition().intValue(), requestBody.getInfoListItemIds());
        return this.infoListDisplayService.getInfoListView(infoListId);
    }
}

