/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.home;

import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.Locale;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.internal.display.home.HomeWorkspaceData;
import org.squashtest.tm.service.internal.display.home.HomeWorkspaceDisplayService;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;

@RestController
@RequestMapping(value={"backend/home-workspace"})
public class HomeWorkspaceController {
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;
    private final HomeWorkspaceDisplayService homeWorkspaceDisplayService;

    public HomeWorkspaceController(HomeWorkspaceDisplayService homeWorkspaceDisplayService, @Named(value="customReport.dashboardBuilder") Provider<JsonCustomReportDashboardBuilder> builderProvider, CustomReportLibraryNodeService customReportLibraryNodeService) {
        this.homeWorkspaceDisplayService = homeWorkspaceDisplayService;
        this.builderProvider = builderProvider;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
    }

    @GetMapping
    public HomeWorkspaceData loadHomeWorkspace(Locale locale) {
        HomeWorkspaceData homeWorkspaceData = this.homeWorkspaceDisplayService.getWorkspacePayload();
        Long dashboardId = homeWorkspaceData.getFavoriteDashboardId();
        if (dashboardId != null) {
            CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(homeWorkspaceData.getFavoriteDashboardId());
            homeWorkspaceData.setDashboard(((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(dashboardId, dashboard, locale));
        }
        return homeWorkspaceData;
    }
}

