/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.export;

import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.List;
import org.springframework.context.MessageSource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;

@RestController
@RequestMapping(value={"backend/test-case/export"})
public class TestCaseExportController {
    private static final String CALLS = "calls";
    private static final String TEST_CASE_SEARCH = "test-case-search";
    private final MessageSource messageSource;
    private final TestCaseLibraryNavigationService testCaseLibraryNavigationService;

    public TestCaseExportController(MessageSource messageSource, TestCaseLibraryNavigationService testCaseLibraryNavigationService) {
        this.messageSource = messageSource;
        this.testCaseLibraryNavigationService = testCaseLibraryNavigationService;
    }

    @GetMapping(value={"/content/xls"}, produces={"application/octet-stream"}, params={"filename", "libraries", "nodes", "calls", "keep-rte-format"})
    public FileSystemResource exportAsExcel(@RequestParam(value="filename") String filename, @RequestParam(value="libraries") List<Long> libraryIds, @RequestParam(value="nodes") List<Long> nodeIds, @RequestParam(value="calls") Boolean includeCalledTests, @RequestParam(value="keep-rte-format") Boolean keepRteFormat, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ".xls");
        File export = this.testCaseLibraryNavigationService.exportTestCaseAsExcel(libraryIds, nodeIds, includeCalledTests.booleanValue(), keepRteFormat.booleanValue(), this.messageSource);
        return new FileSystemResource(export);
    }

    @GetMapping(value={"/content/keyword-scripts"}, produces={"application/octet-stream"}, params={"filename", "libraries", "nodes"})
    public FileSystemResource exportKeywordScripts(@RequestParam(value="filename") String filename, @RequestParam(value="libraries") List<Long> libraryIds, @RequestParam(value="nodes") List<Long> nodeIds, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ".zip");
        File file = this.testCaseLibraryNavigationService.exportKeywordTestCaseAsScriptFiles(libraryIds, nodeIds, this.messageSource);
        return new FileSystemResource(file);
    }

    @GetMapping(value={"/content/features"}, produces={"application/octet-stream"}, params={"filename", "libraries", "nodes"})
    public FileSystemResource exportGherkinFeatures(@RequestParam(value="filename") String filename, @RequestParam(value="libraries") List<Long> libraryIds, @RequestParam(value="nodes") List<Long> nodeIds, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ".zip");
        File file = this.testCaseLibraryNavigationService.exportGherkinTestCaseAsFeatureFiles(libraryIds, nodeIds, this.messageSource);
        return new FileSystemResource(file);
    }

    @GetMapping(value={"/searchExports"}, produces={"application/octet-stream"}, params={"filename", "nodes", "calls", "keep-rte-format"})
    public FileSystemResource searchExportAsExcel(@RequestParam(value="filename") String filename, @RequestParam(value="nodes") List<Long> nodeIds, @RequestParam(value="calls") Boolean includeCalledTests, @RequestParam(value="type") String type, @RequestParam(value="keep-rte-format") Boolean keepRteFormat, @RequestParam(value="simplifiedColumnDisplayGridIds") List<String> simplifiedColumnDisplayGridIds, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ".xls");
        boolean simplifiedColumnDisplay = simplifiedColumnDisplayGridIds.contains(TEST_CASE_SEARCH);
        File export = this.testCaseLibraryNavigationService.searchExportTestCaseAsExcel(nodeIds, includeCalledTests.booleanValue(), keepRteFormat.booleanValue(), this.messageSource, type, Boolean.valueOf(simplifiedColumnDisplay));
        return new FileSystemResource(export);
    }
}

