/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.export;

import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.requirement.ExportRequirementData;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.web.backend.controller.export.ExportUtil;
import org.squashtest.tm.web.backend.report.service.JasperReportsService;

@RestController
@RequestMapping(value={"/backend/requirement/export"})
public class RequirementExportController {
    private static final String JASPER_EXPORT_FILE = "WEB-INF/reports/requirement-export.jasper";
    private static final String REQUIREMENT_SEARCH = "requirement-search";
    private final MessageSource messageSource;
    private final JasperReportsService jrServices;
    private final RequirementLibraryNavigationService requirementLibraryNavigationService;

    public RequirementExportController(MessageSource messageSource, JasperReportsService jrServices, RequirementLibraryNavigationService requirementLibraryNavigationService) {
        this.messageSource = messageSource;
        this.jrServices = jrServices;
        this.requirementLibraryNavigationService = requirementLibraryNavigationService;
    }

    @GetMapping(value={"searchExports"}, produces={"application/octet-stream"}, params={"filename", "nodes", "add-linked-low-level-req", "keep-rte-format"})
    public FileSystemResource searchExportAsExcel(@RequestParam(value="filename") String filename, @RequestParam(value="nodes") List<Long> nodeIds, @RequestParam(value="type") String type, @RequestParam(value="add-linked-low-level-req") Boolean addLinkedLowLevelReq, @RequestParam(value="keep-rte-format") Boolean keepRteFormat, @RequestParam(value="simplifiedColumnDisplayGridIds") List<String> simplifiedColumnDisplayGridIds, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ".xls");
        boolean simplifiedColumnDisplay = simplifiedColumnDisplayGridIds.contains(REQUIREMENT_SEARCH);
        File export = this.requirementLibraryNavigationService.searchExportRequirementAsExcel(nodeIds, keepRteFormat.booleanValue(), addLinkedLowLevelReq.booleanValue(), this.messageSource, type, Boolean.valueOf(simplifiedColumnDisplay));
        return new FileSystemResource(export);
    }

    @GetMapping(value={"/content/xls"}, produces={"application/octet-stream"}, params={"filename", "libraries", "nodes", "add-linked-low-level-req", "keep-rte-format"})
    public FileSystemResource exportAsExcel(@RequestParam(value="filename") String fileName, @RequestParam(value="libraries") List<Long> libraryIds, @RequestParam(value="nodes") List<Long> nodeIds, @RequestParam(value="add-linked-low-level-req") Boolean addLinkedLowLevelReq, @RequestParam(value="keep-rte-format") Boolean keepRtxFormat, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".xls");
        File export = this.requirementLibraryNavigationService.exportRequirementAsExcel(libraryIds, nodeIds, addLinkedLowLevelReq.booleanValue(), keepRtxFormat.booleanValue(), this.messageSource);
        return new FileSystemResource(export);
    }

    @Deprecated
    @GetMapping(value={"/content/csv"}, produces={"application/octet-stream"}, params={"filename", "libraries", "nodes", "keep-rte-format", "isCurrentVersion"})
    public void exportAsCsv(@RequestParam(value="filename") String filename, @RequestParam(value="libraries") List<Long> libraryIds, @RequestParam(value="nodes") List<Long> nodeIds, @RequestParam(value="keep-rte-format") Boolean keepRteFormat, @RequestParam(value="isCurrentVersion") Boolean isCurrentVersion, Locale locale, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ".xls");
        ArrayList dataSource = new ArrayList();
        if (!libraryIds.isEmpty()) {
            dataSource.addAll(this.requirementLibraryNavigationService.findRequirementsToExportFromLibrary(libraryIds));
        }
        if (!nodeIds.isEmpty()) {
            dataSource.addAll(this.requirementLibraryNavigationService.findRequirementsToExportFromNodes(nodeIds));
        }
        this.convertHtmlSpecialCharactersToUnicode(dataSource);
        this.printExport(dataSource, filename, response, locale, keepRteFormat);
    }

    private void printExport(List<ExportRequirementData> dataSource, String filename, HttpServletResponse response, Locale locale, Boolean keepRteFormat) {
        ExportUtil.printExport(dataSource, (String)filename, (String)JASPER_EXPORT_FILE, (HttpServletResponse)response, (Locale)locale, (String)"csv", (boolean)keepRteFormat, new HashMap(), (MessageSource)this.messageSource, (JasperReportsService)this.jrServices);
    }

    private void convertHtmlSpecialCharactersToUnicode(List<ExportRequirementData> dataSource) {
        for (ExportRequirementData data : dataSource) {
            data.setDescription(HtmlUtils.htmlUnescape((String)data.getDescription()));
        }
    }
}

