/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.export;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.web.backend.controller.export.grid.CsvGridExporter;
import org.squashtest.tm.web.backend.controller.export.grid.GridExportModel;
import org.squashtest.tm.web.backend.controller.export.grid.XlsGridExporter;

@RestController
@RequestMapping(value={"/backend/grid-export"})
public class GridExportController {
    @PostMapping(value={"/xlsx"})
    public ResponseEntity<InputStreamResource> export(@RequestBody GridExportModel gridExportModel) {
        try {
            XlsGridExporter exporter = new XlsGridExporter(gridExportModel);
            File export = exporter.export();
            InputStreamResource resource = new InputStreamResource((InputStream)new FileInputStream(export));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=" + export.getName()})).contentType(MediaType.APPLICATION_OCTET_STREAM).contentLength(export.length()).body((Object)resource);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @PostMapping(value={"/csv"})
    public ResponseEntity<InputStreamResource> exportCsv(@RequestBody GridExportModel gridExportModel) {
        try {
            CsvGridExporter exporter = new CsvGridExporter(gridExportModel);
            File export = exporter.export();
            InputStreamResource resource = new InputStreamResource((InputStream)new FileInputStream(export));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=" + export.getName()})).contentType(MediaType.APPLICATION_OCTET_STREAM).contentLength(export.length()).body((Object)resource);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

