/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.export;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceResourceBundle;
import org.squashtest.tm.domain.library.AbstractExportData;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.web.backend.report.service.JasperReportsService;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ExportUtil {
    private static final int EOF = -1;

    private ExportUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void printExport(List<? extends AbstractExportData> dataSource, String filename, String jasperFile, HttpServletResponse response, Locale locale, String format, boolean keepRteFormat, Map<String, Object> reportParameters, MessageSource messageSource, JasperReportsService jrServices) {
        try {
            if (!keepRteFormat) {
                ExportUtil.removeRteFormat(dataSource);
            }
            reportParameters.put("REPORT_LOCALE", locale);
            reportParameters.put("REPORT_RESOURCE_BUNDLE", new MessageSourceResourceBundle(messageSource, locale));
            InputStream jsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(jasperFile);
            InputStream reportStream = jrServices.getReportAsStream(jsStream, format, dataSource, reportParameters);
            ServletOutputStream servletStream = response.getOutputStream();
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=" + filename + "." + format);
            ExportUtil.flushStreams((InputStream)reportStream, (ServletOutputStream)servletStream);
            reportStream.close();
            servletStream.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void flushStreams(InputStream inStream, ServletOutputStream outStream) throws IOException {
        int readByte;
        do {
            if ((readByte = inStream.read()) == -1) continue;
            outStream.write(readByte);
        } while (readByte != -1);
    }

    private static void removeRteFormat(List<? extends AbstractExportData> dataSource) {
        for (AbstractExportData abstractExportData : dataSource) {
            String htmlDescription = abstractExportData.getDescription();
            String description = HTMLCleanupUtils.htmlToTrimmedText((String)htmlDescription);
            abstractExportData.setDescription(description);
        }
    }
}

