/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.execution;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.campaign.TestPlanExecutionProcessingService;
import org.squashtest.tm.service.internal.display.dto.execution.TestPlanResume;
import org.squashtest.tm.web.backend.controller.execution.FiltersContainer;
import org.squashtest.tm.web.backend.controller.form.model.IdList;

@RestController
@RequestMapping(value={"/backend/test-suite/{testSuiteId}/test-plan"})
public class TestSuiteExecutionRunnerController {
    private final TestPlanExecutionProcessingService<TestPlanResume.TestSuiteTestPlanResume> testSuiteExecutionProcessingService;

    public TestSuiteExecutionRunnerController(TestPlanExecutionProcessingService<TestPlanResume.TestSuiteTestPlanResume> testSuiteExecutionProcessingService) {
        this.testSuiteExecutionProcessingService = testSuiteExecutionProcessingService;
    }

    @PostMapping(value={"/resume"})
    public TestPlanResume.TestSuiteTestPlanResume resumeTestSuite(@PathVariable long testSuiteId) {
        return (TestPlanResume.TestSuiteTestPlanResume)this.testSuiteExecutionProcessingService.startResume(testSuiteId);
    }

    @PostMapping(value={"/resume-filtered-selection"})
    public TestPlanResume resumeIterationWithFilter(@PathVariable long testSuiteId, @RequestBody FiltersContainer filtersContainer) {
        return this.testSuiteExecutionProcessingService.resumeWithFilteredTestPlan(testSuiteId, filtersContainer.getFilterValues());
    }

    @PostMapping(value={"/relaunch"})
    public TestPlanResume.TestSuiteTestPlanResume relaunchTestSuite(@PathVariable long testSuiteId) {
        return (TestPlanResume.TestSuiteTestPlanResume)this.testSuiteExecutionProcessingService.relaunch(testSuiteId);
    }

    @PostMapping(value={"/relaunch-filtered-selection"})
    public TestPlanResume relaunchIterationWithFilter(@PathVariable long testSuiteId, @RequestBody FiltersContainer filtersContainer) {
        return this.testSuiteExecutionProcessingService.relaunchFilteredTestPlan(testSuiteId, filtersContainer.getFilterValues());
    }

    @RequestMapping(value={"/{testPlanItemId}/next-execution"})
    public TestPlanResume.TestSuiteTestPlanResume moveToNextTestCase(@PathVariable(value="testPlanItemId") long testPlanItemId, @PathVariable(value="testSuiteId") long testSuiteId) {
        return (TestPlanResume.TestSuiteTestPlanResume)this.testSuiteExecutionProcessingService.startResumeNextExecution(testSuiteId, testPlanItemId);
    }

    @RequestMapping(value={"/{testPlanItemId}/next-execution-filtered-selection"})
    public TestPlanResume moveToNextTestCaseOfFilteredTestPlan(@PathVariable(value="testPlanItemId") long testPlanItemId, @PathVariable(value="testSuiteId") long testSuiteId, @RequestBody IdList partialTestPlanItemIds) {
        return this.testSuiteExecutionProcessingService.resumeNextExecutionOfFilteredTestPlan(testSuiteId, testPlanItemId, partialTestPlanItemIds.getIds());
    }
}

