/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.execution;

import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.execution.ExploratorySessionOverviewDisplayService;
import org.squashtest.tm.service.execution.ExecutionDeletionService;
import org.squashtest.tm.service.execution.ExploratorySessionOverviewModificationService;
import org.squashtest.tm.service.internal.display.dto.UserView;
import org.squashtest.tm.service.internal.display.dto.execution.ExploratorySessionOverviewView;
import org.squashtest.tm.service.internal.display.dto.execution.SessionNoteDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.web.backend.controller.execution.ExploratorySessionOverviewController;

@RestController
@RequestMapping(value={"/backend/session-overview/"})
public class ExploratorySessionOverviewController {
    private final ExploratorySessionOverviewDisplayService exploratorySessionOverviewDisplayService;
    private final ExploratorySessionOverviewModificationService exploratorySessionOverviewModificationService;
    private final ExecutionDeletionService executionDeletionService;

    public ExploratorySessionOverviewController(ExploratorySessionOverviewDisplayService exploratorySessionOverviewDisplayService, ExploratorySessionOverviewModificationService exploratorySessionOverviewModificationService, ExecutionDeletionService executionDeletionService) {
        this.exploratorySessionOverviewDisplayService = exploratorySessionOverviewDisplayService;
        this.exploratorySessionOverviewModificationService = exploratorySessionOverviewModificationService;
        this.executionDeletionService = executionDeletionService;
    }

    @GetMapping(value={"{overviewId}"})
    public ExploratorySessionOverviewView getView(@PathVariable Long overviewId) {
        return this.exploratorySessionOverviewDisplayService.findById(overviewId.longValue());
    }

    @GetMapping(value={"{overviewId}/unassigned-users"})
    public List<UserView> getUnassignedUsers(@PathVariable Long overviewId) {
        return this.exploratorySessionOverviewDisplayService.getUnassignedUsers(overviewId);
    }

    @PostMapping(value={"{overviewId}/executions"})
    public GridResponse getExecutions(@PathVariable Long overviewId, @RequestBody GridRequest gridRequest) {
        return this.exploratorySessionOverviewDisplayService.getExecutionGrid(overviewId, gridRequest);
    }

    @PostMapping(value={"{overviewId}/new-execution"})
    public void addNewExecution(@PathVariable Long overviewId) {
        this.exploratorySessionOverviewModificationService.addNewExecution(overviewId);
    }

    @PostMapping(value={"{overviewId}/due-date"})
    public void updateDueDate(@PathVariable Long overviewId, @RequestBody SessionOverviewPatch requestBody) {
        this.exploratorySessionOverviewModificationService.updateDueDate(overviewId, requestBody.dueDate());
    }

    @PostMapping(value={"{overviewId}/execution-status"})
    public void updateExecutionStatus(@PathVariable Long overviewId, @RequestBody SessionOverviewPatch requestBody) {
        this.exploratorySessionOverviewModificationService.updateExecutionStatus(overviewId, requestBody.executionStatus());
    }

    @PostMapping(value={"{overviewId}/session-duration"})
    public void updateSessionDuration(@PathVariable Long overviewId, @RequestBody SessionOverviewPatch requestBody) {
        this.exploratorySessionOverviewModificationService.updateSessionDuration(overviewId, requestBody.sessionDuration());
    }

    @DeleteMapping(value={"{overviewId}/executions/{executionIds}"})
    public void deleteExecutions(@PathVariable Long overviewId, @PathVariable(value="executionIds") List<Long> executionIds) {
        this.executionDeletionService.deleteExecutions(executionIds);
    }

    @PostMapping(value={"{overviewId}/add-executions-with-users/{userIds}"})
    public void addExecutionsWithUsers(@PathVariable Long overviewId, @PathVariable(value="userIds") List<Long> userIds) {
        this.exploratorySessionOverviewModificationService.addExecutionsWithUsers(overviewId, userIds);
    }

    @PostMapping(value={"{overviewId}/start-session"})
    public void startSession(@PathVariable Long overviewId) {
        this.exploratorySessionOverviewModificationService.startSessionAndUpdateExecutionStatus(overviewId);
    }

    @PostMapping(value={"{overviewId}/end-session"})
    public void endSession(@PathVariable Long overviewId) {
        this.exploratorySessionOverviewModificationService.endSession(overviewId);
    }

    @PostMapping(value={"{overviewId}/comments"})
    public void updateComment(@PathVariable Long overviewId, @RequestBody SessionOverviewPatch requestBody) {
        this.exploratorySessionOverviewModificationService.updateComments(overviewId, requestBody.comments());
    }

    @GetMapping(value={"{overviewId}/session-notes"})
    public List<SessionNoteDto> getSessionNotes(@PathVariable Long overviewId) {
        return this.exploratorySessionOverviewDisplayService.getAllSessionNotes(overviewId);
    }
}

