/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.execution;

import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.execution.ExecutionFlag;
import org.squashtest.tm.service.display.execution.AutomatedExecutionDisplayService;
import org.squashtest.tm.service.execution.automatedexecution.AutomatedExecutionFlagService;
import org.squashtest.tm.service.internal.display.dto.FailureDetailDto;
import org.squashtest.tm.web.backend.controller.execution.AutomatedExecutionController;

@RestController
@RequestMapping(value={"/backend/execution-extender/{executionExtenderId}"})
public class AutomatedExecutionController {
    private final AutomatedExecutionDisplayService automatedExecutionDisplayService;
    private final AutomatedExecutionFlagService automatedExecutionFlagService;

    public AutomatedExecutionController(AutomatedExecutionDisplayService automatedExecutionDisplayService, AutomatedExecutionFlagService automatedExecutionFlagService) {
        this.automatedExecutionDisplayService = automatedExecutionDisplayService;
        this.automatedExecutionFlagService = automatedExecutionFlagService;
    }

    @GetMapping(value={"failure-detail-list"})
    public List<FailureDetailDto> getFailureDetailList(@PathVariable(value="executionExtenderId") long executionExtenderId) {
        return this.automatedExecutionDisplayService.findFailureDetailList(Long.valueOf(executionExtenderId));
    }

    @PostMapping(value={"/flag"})
    public void updateFlag(@PathVariable(value="executionExtenderId") long executionExtenderId, @RequestBody UpdateFlagRequest request) {
        ExecutionFlag flag = request.flag();
        this.automatedExecutionFlagService.updateFlag(executionExtenderId, flag);
    }
}

