/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.util.Date;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignStatus;
import org.squashtest.tm.service.campaign.CampaignModificationService;
import org.squashtest.tm.service.campaign.CustomCampaignModificationService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.display.campaign.CampaignDisplayService;
import org.squashtest.tm.service.internal.display.dto.campaign.IterationPlanningDto;
import org.squashtest.tm.web.backend.controller.campaign.CampaignViewModificationController;

@RestController
@RequestMapping(value={"backend/campaign/{campaignId}"})
public class CampaignViewModificationController {
    private final CustomCampaignModificationService customCampaignModificationService;
    private final CampaignModificationService campaignModificationService;
    private final IterationModificationService iterationModificationService;
    private final CampaignDisplayService campaignDisplayService;

    public CampaignViewModificationController(CustomCampaignModificationService customCampaignModificationService, CampaignModificationService campaignModificationService, IterationModificationService iterationModificationService, CampaignDisplayService campaignDisplayService) {
        this.customCampaignModificationService = customCampaignModificationService;
        this.campaignModificationService = campaignModificationService;
        this.iterationModificationService = iterationModificationService;
        this.campaignDisplayService = campaignDisplayService;
    }

    @PostMapping(value={"/name"})
    public void rename(@PathVariable Long campaignId, @RequestBody CampaignPatch patch) {
        this.customCampaignModificationService.rename(campaignId.longValue(), patch.getName());
    }

    @PostMapping(value={"/reference"})
    public void changeReference(@PathVariable Long campaignId, @RequestBody CampaignPatch patch) {
        this.campaignModificationService.changeReference(campaignId.longValue(), patch.getReference());
    }

    @PostMapping(value={"/description"})
    public void changeDescription(@PathVariable Long campaignId, @RequestBody CampaignPatch patch) {
        this.campaignModificationService.changeDescription(campaignId.longValue(), patch.getDescription());
    }

    @PostMapping(value={"/campaign-status"})
    public void changeCampaignStatus(@PathVariable Long campaignId, @RequestBody CampaignPatch patch) {
        this.campaignModificationService.changeStatus(campaignId.longValue(), CampaignStatus.valueOf((String)patch.getCampaignStatus()));
    }

    @PostMapping(value={"/milestone/{milestoneId}"})
    public void bindMilestone(@PathVariable Long campaignId, @PathVariable Long milestoneId) {
        this.campaignModificationService.bindMilestone(campaignId.longValue(), milestoneId.longValue());
    }

    @DeleteMapping(value={"/milestone"})
    public void unbindMilestones(@PathVariable Long campaignId, @RequestBody List<Long> milestoneIds) {
        this.campaignModificationService.unbindMilestones(campaignId.longValue(), milestoneIds);
    }

    @DeleteMapping(value={"/milestone/{milestoneId}"})
    public void unbindSingleMilestone(@PathVariable Long campaignId, @PathVariable Long milestoneId) {
        this.campaignModificationService.unbindSingleMilestone(campaignId.longValue(), milestoneId);
    }

    @PostMapping(value={"/scheduled-start-date"})
    public void setScheduledStart(@PathVariable long campaignId, @RequestBody CampaignPatch campaignPatch) {
        this.campaignModificationService.changeScheduledStartDate(campaignId, campaignPatch.getScheduledStartDate());
    }

    @PostMapping(value={"/scheduled-end-date"})
    public void setScheduledEnd(@PathVariable long campaignId, @RequestBody CampaignPatch campaignPatch) {
        this.campaignModificationService.changeScheduledEndDate(campaignId, campaignPatch.getScheduledEndDate());
    }

    @PostMapping(value={"/actual-start-date"})
    public void setActualStart(@PathVariable long campaignId, @RequestBody CampaignPatch campaignPatch) {
        this.campaignModificationService.changeActualStartDate(campaignId, campaignPatch.getActualStartDate());
    }

    @PostMapping(value={"/actual-end-date"})
    public void setActualEnd(@PathVariable long campaignId, @RequestBody CampaignPatch campaignPatch) {
        this.campaignModificationService.changeActualEndDate(campaignId, campaignPatch.getActualEndDate());
    }

    @PostMapping(value={"/actual-start-auto"})
    public Date setActualStartAuto(@PathVariable long campaignId, @RequestBody CampaignPatch campaignPatch) {
        this.campaignModificationService.changeActualStartAuto(campaignId, campaignPatch.getActualStartAuto().booleanValue());
        Campaign campaign = this.campaignModificationService.findById(campaignId);
        return campaign.getActualStartDate();
    }

    @PostMapping(value={"/actual-end-auto"})
    public Date setActualEndAuto(@PathVariable long campaignId, @RequestBody CampaignPatch campaignPatch) {
        this.campaignModificationService.changeActualEndAuto(campaignId, campaignPatch.getActualEndAuto().booleanValue());
        Campaign campaign = this.campaignModificationService.findById(campaignId);
        return campaign.getActualEndDate();
    }

    @GetMapping(value={"/iterations"})
    public List<IterationPlanningDto> getIterations(@PathVariable long campaignId) {
        return this.campaignDisplayService.findIterationsPlanningByCampaign(Long.valueOf(campaignId));
    }

    @PostMapping(value={"/iterations/planning"})
    public void setIterationsPlanning(@RequestBody IterationPlanningPatch patch) {
        for (IterationPlanningDto iter : patch.iterationPlannings) {
            this.iterationModificationService.changeScheduledStartDate(iter.getId().longValue(), iter.getScheduledStartDate());
            this.iterationModificationService.changeScheduledEndDate(iter.getId().longValue(), iter.getScheduledEndDate());
        }
    }
}

