/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.Collections;
import java.util.Locale;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.display.campaign.CampaignDisplayService;
import org.squashtest.tm.service.internal.display.dto.campaign.CampaignDto;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomReportDashboardDto;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.statistics.campaign.StatisticsBundle;
import org.squashtest.tm.web.backend.controller.campaign.CampaignViewController;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;

@RestController
@RequestMapping(value={"/backend/campaign-view"})
public class CampaignViewController {
    private CampaignDisplayService campaignDisplayService;
    private CampaignLibraryNavigationService campaignLibraryNavigationService;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    @Named(value="customReport.dashboardBuilder")
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;

    public CampaignViewController(CampaignDisplayService campaignDisplayService, CampaignLibraryNavigationService campaignLibraryNavigationService, CustomReportLibraryNodeService customReportLibraryNodeService, Provider<JsonCustomReportDashboardBuilder> builderProvider) {
        this.campaignDisplayService = campaignDisplayService;
        this.campaignLibraryNavigationService = campaignLibraryNavigationService;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.builderProvider = builderProvider;
    }

    @GetMapping(value={"/{campaignId}"})
    public CampaignDto getCampaignView(@PathVariable long campaignId, Locale locale) {
        CampaignDto dto = this.campaignDisplayService.getCampaignView(campaignId);
        if (dto.isShouldShowFavoriteDashboard() && dto.isCanShowFavoriteDashboard()) {
            EntityReference library = new EntityReference(EntityType.CAMPAIGN, Long.valueOf(campaignId));
            CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(dto.getFavoriteDashboardId());
            CustomReportDashboardDto dashboardScopeDto = new CustomReportDashboardDto(Workspace.CAMPAIGN, Collections.singletonList(library), false, false, true);
            JsonCustomReportDashboard jsonDashboard = ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(dto.getFavoriteDashboardId(), dashboard, locale, dashboardScopeDto);
            dto.setDashboard(jsonDashboard);
        }
        return dto;
    }

    @PostMapping(value={"/{campaignId}/statistics"})
    public StatisticsBundle getCampaignStatistics(@PathVariable long campaignId, @RequestBody StatisticsScopePatch patch) {
        return this.campaignLibraryNavigationService.gatherCampaignStatisticsBundle(campaignId, patch.lastExecutionScope);
    }
}

