/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.util.Collections;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.campaign.AutomatedSuiteDisplayService;
import org.squashtest.tm.service.internal.display.dto.campaign.AutomatedSuiteExecutionReportDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.testautomation.AutomatedSuiteManagerService;

@RestController
@RequestMapping(value={"backend/automated-suite/{automatedSuiteId}"})
public class AutomatedSuiteController {
    private final AutomatedSuiteDisplayService automatedSuiteDisplayService;
    private final AutomatedSuiteManagerService automatedSuiteManagerService;

    public AutomatedSuiteController(AutomatedSuiteDisplayService automatedSuiteDisplayService, AutomatedSuiteManagerService automatedSuiteManagerService) {
        this.automatedSuiteDisplayService = automatedSuiteDisplayService;
        this.automatedSuiteManagerService = automatedSuiteManagerService;
    }

    @PostMapping(value={"/executions"})
    public GridResponse findExecutionByAutomatedSuite(@PathVariable Long automatedSuiteId, @RequestBody GridRequest request) {
        return this.automatedSuiteDisplayService.findExecutionByAutomatedSuiteID(automatedSuiteId, request);
    }

    @GetMapping(value={"/report-urls"})
    public AutomatedSuiteExecutionReportDto findReportUrlsByAutomatedSuite(@PathVariable Long automatedSuiteId) {
        return this.automatedSuiteDisplayService.findReportUrlsByAutomatedSuite(automatedSuiteId);
    }

    @PostMapping(value={"/stop-workflows"})
    public boolean stopWorkflows(@PathVariable Long automatedSuiteId, @RequestBody List<String> workflows) {
        return this.automatedSuiteManagerService.stopWorkflows(automatedSuiteId, workflows);
    }

    @PostMapping(value={"/attachment-prune"}, params={"complete"})
    public void pruneAutomatedSuite(@PathVariable Long automatedSuiteId, @RequestParam(value="complete") boolean complete) {
        this.automatedSuiteManagerService.pruneAutomatedSuites(Collections.singletonList(automatedSuiteId), complete);
    }
}

