/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.bugtracker;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.web.backend.controller.bugtracker.BugTrackerInfoController;

@RestController
@RequestMapping(value={"/backend/issues/projects/{projectId}/bugtracker"})
public class BugTrackerInfoController {
    private final GenericProjectManagerService projectManager;

    public BugTrackerInfoController(GenericProjectManagerService projectManager) {
        this.projectManager = projectManager;
    }

    @GetMapping
    BugTrackerInfo getBugtrackerInfo(@PathVariable long projectId) {
        GenericProject project = this.projectManager.findById(projectId);
        BugTrackerInfo response = new BugTrackerInfo();
        if (project.isBoundToBugtracker()) {
            response.setProjectNames(project.getBugtrackerProjectNames());
            response.setKind(project.getBugTracker().getKind());
            response.setBugTrackerName(project.getBugTracker().getName());
        }
        return response;
    }
}

