/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.actionword;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.NodeWorkspace;
import org.squashtest.tm.domain.actionword.ActionWordLibraryNode;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntity;
import org.squashtest.tm.exception.library.RightsUnsuficientsForOperationException;
import org.squashtest.tm.service.actionword.ActionWordLibraryNodeService;
import org.squashtest.tm.service.actionword.ActionWordWorkspaceService;
import org.squashtest.tm.service.deletion.Node;
import org.squashtest.tm.service.deletion.NodeMovement;
import org.squashtest.tm.service.deletion.NodeReferenceChanged;
import org.squashtest.tm.service.deletion.NodeRenaming;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.display.workspace.tree.SingleHierarchyTreeBrowser;
import org.squashtest.tm.service.display.workspace.tree.TreeNodeCollectorService;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.TreeGridResponse;
import org.squashtest.tm.service.internal.display.grid.TreeRequest;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.web.backend.controller.actionword.ActionWordFormModel;
import org.squashtest.tm.web.backend.controller.form.model.EntityFormModelValidator;
import org.squashtest.tm.web.backend.controller.form.model.NodeList;
import org.squashtest.tm.web.backend.controller.form.model.RefreshTreeNodeModel;
import org.squashtest.tm.web.backend.controller.navigation.Messages;

@RestController
@RequestMapping(value={"backend/action-word-tree"})
public class ActionWordNavigationController {
    public static final Logger LOGGER = LoggerFactory.getLogger(ActionWordNavigationController.class);
    private static final String ADD_ACTION_WORD = "add-action-word";
    private final SingleHierarchyTreeBrowser treeBrowser;
    private final ActionWordLibraryNodeService actionWordLibraryNodeService;
    private final TreeNodeCollectorService treeNodeCollectorService;
    private final MessageSource messageSource;
    private final ActionWordWorkspaceService actionWordWorkspaceService;
    private final UltimateLicenseAvailabilityService ultimateLicenseService;

    @Autowired
    public ActionWordNavigationController(SingleHierarchyTreeBrowser treeBrowser, ActionWordLibraryNodeService actionWordLibraryNodeService, TreeNodeCollectorService treeNodeCollectorService, MessageSource messageSource, Optional<ActionWordWorkspaceService> actionWordWorkspaceService, UltimateLicenseAvailabilityService ultimateLicenseService) {
        this.treeBrowser = treeBrowser;
        this.actionWordLibraryNodeService = actionWordLibraryNodeService;
        this.treeNodeCollectorService = treeNodeCollectorService;
        this.messageSource = messageSource;
        this.actionWordWorkspaceService = actionWordWorkspaceService.orElse(null);
        this.ultimateLicenseService = ultimateLicenseService;
    }

    @PostMapping
    public TreeGridResponse getInitialRows(@RequestBody TreeRequest treeRequest) {
        this.ultimateLicenseService.checkIfAvailable();
        return this.treeBrowser.getInitialTree(NodeWorkspace.ACTION_WORD, NodeReference.fromNodeIds((Collection)treeRequest.getOpenedNodes()), NodeReference.fromNodeIds((Collection)treeRequest.getSelectedNodes()));
    }

    @GetMapping(value={"/{ids}/content"})
    public TreeGridResponse getChildren(@PathVariable List<String> ids) {
        this.ultimateLicenseService.checkIfAvailable();
        Set nodeReference = NodeReference.fromNodeIds(ids);
        return this.treeBrowser.findSubHierarchy(nodeReference, new HashSet(nodeReference));
    }

    @PostMapping(value={"/refresh"})
    public TreeGridResponse refreshTree(@RequestBody RefreshTreeNodeModel refreshTreeNodeModel) {
        this.ultimateLicenseService.checkIfAvailable();
        return this.treeBrowser.findSubHierarchy(NodeReference.fromNodeIds((Collection)refreshTreeNodeModel.getNodeIds()), new HashSet(refreshTreeNodeModel.getNodeList().getNodeReferences()));
    }

    @PostMapping(value={"/{ids}/refresh"})
    public TreeGridResponse refreshNodes(@PathVariable List<String> ids, @RequestBody NodeList openedNodes) {
        this.ultimateLicenseService.checkIfAvailable();
        return this.treeBrowser.findSubHierarchy(NodeReference.fromNodeIds(ids), new HashSet(openedNodes.getNodeReferences()));
    }

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"new-action-word"})
    public DataRow addNewActionWord(@RequestBody ActionWordFormModel actionWordFormModel) throws BindException {
        this.ultimateLicenseService.checkIfAvailable();
        this.validateActionWordFormModel(actionWordFormModel);
        Long parentId = actionWordFormModel.getParentNodeReference().getId();
        ActionWordLibraryNode newNode = this.actionWordLibraryNodeService.createNewNode(parentId, (ActionWordTreeEntity)actionWordFormModel.getActionWord());
        return this.treeNodeCollectorService.collectNode(NodeType.ACTION_WORD, (Identified)newNode);
    }

    @PostMapping(value={"/{destinationId}/content/paste"})
    public void copyNodes(@RequestBody NodeList nodeList, @PathVariable(value="destinationId") String destinationId) {
        NodeReference nodeReference = NodeReference.fromNodeId((String)destinationId);
        List copiedNodeIds = nodeList.getIds();
        try {
            if (Objects.requireNonNull(nodeReference.getNodeType()) != NodeType.ACTION_WORD_LIBRARY) {
                throw new IllegalArgumentException("copy nodes : specified destination type doesn't exists : " + String.valueOf(nodeReference.getNodeType()));
            }
            this.actionWordLibraryNodeService.copyNodes(copiedNodeIds, nodeReference.getId().longValue());
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @PostMapping(value={"{destinationId}/content/paste-simulation"})
    public boolean simulateCopyNodesToDrives(@RequestBody NodeList nodeList, @PathVariable(value="destinationId") String destinationId) {
        NodeReference nodeReference = NodeReference.fromNodeId((String)destinationId);
        List copiedNodeIds = nodeList.getIds();
        return this.actionWordLibraryNodeService.simulateCopyNodes(copiedNodeIds, nodeReference.getId().longValue());
    }

    @PostMapping(value={"/{destinationRef}/content/move"})
    public void moveNodes(@RequestBody NodeList nodeList, @PathVariable(value="destinationRef") String destinationRef) {
        this.ultimateLicenseService.checkIfAvailable();
        NodeReference nodeReference = NodeReference.fromNodeId((String)destinationRef);
        Long destinationId = nodeReference.getId();
        NodeType destinationType = nodeReference.getNodeType();
        List movedNodeIds = nodeList.getIds();
        try {
            if (Objects.requireNonNull(destinationType) != NodeType.ACTION_WORD_LIBRARY) {
                throw new IllegalArgumentException("move nodes : specified destination type doesn't exists : " + String.valueOf(destinationType));
            }
            this.actionWordLibraryNodeService.moveNodes(movedNodeIds, destinationId.longValue());
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @GetMapping(value={"/deletion-simulation/{nodeIds}"})
    public Messages simulateNodeDeletion(@PathVariable(value="nodeIds") List<Long> nodeIds, Locale locale) {
        List reports = this.actionWordLibraryNodeService.previewAffectedNodes(nodeIds);
        ArrayList reportList = new ArrayList(reports);
        Messages messages = new Messages();
        messages.addMessages(reportList, this.messageSource, locale);
        return messages;
    }

    @GetMapping(value={"/are-all-associated-to-keyword-steps/{nodeIds}"})
    public boolean areAllAssociatedToKeywordTestSteps(@PathVariable(value="nodeIds") Set<Long> nodeIds) {
        return this.getActionWordWorkspaceService().areAllAssociatedToKeywordTestSteps(nodeIds);
    }

    @DeleteMapping(value={"/{nodeIds}"})
    public OperationReport confirmNodeDeletion(@PathVariable(value="nodeIds") List<Long> nodeIds) {
        OperationReport report = this.actionWordLibraryNodeService.delete(nodeIds);
        this.logOperations(report);
        return report;
    }

    private void logOperations(OperationReport report) {
        for (Node deletedNode : report.getRemoved()) {
            LOGGER.info("The node #{} was removed", new Object[]{deletedNode.getResid()});
        }
        for (NodeMovement movedNode : report.getMoved()) {
            LOGGER.info("The nodes #{} were moved to node #{}", new Object[]{movedNode.getMoved().stream().map(Node::getResid).toList(), movedNode.getDest().getResid()});
        }
        for (NodeRenaming renamedNode : report.getRenamed()) {
            LOGGER.info("The node #{} was renamed to {}", new Object[]{renamedNode.getNode().getResid(), renamedNode.getName()});
        }
        for (NodeReferenceChanged nodeReferenceChanged : report.getReferenceChanges()) {
            LOGGER.info("The node #{} reference was changed to {}", new Object[]{nodeReferenceChanged.getNode().getResid(), nodeReferenceChanged.getReference()});
        }
    }

    private void validateActionWordFormModel(ActionWordFormModel actionWordFormModel) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)actionWordFormModel, ADD_ACTION_WORD);
        EntityFormModelValidator entityFormModelValidator = new EntityFormModelValidator();
        entityFormModelValidator.validate((Object)actionWordFormModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
    }

    private ActionWordWorkspaceService getActionWordWorkspaceService() {
        if (Objects.isNull(this.actionWordWorkspaceService)) {
            throw new AccessDeniedException("A dedicated plugin is required to manage action words");
        }
        return this.actionWordWorkspaceService;
    }
}

