/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.jasperreports.processors;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.JEditorPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import net.sf.jasperreports.engine.base.JRBasePrintHyperlink;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.HtmlEditorKitMarkupProcessor;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.MarkupProcessor;
import net.sf.jasperreports.engine.util.MarkupProcessorFactory;
import net.sf.jasperreports.engine.util.StyledTextListInfo;
import net.sf.jasperreports.engine.util.StyledTextListItemInfo;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public class CustomHtmlProcessorFactory
extends HtmlEditorKitMarkupProcessor
implements MarkupProcessorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomHtmlProcessorFactory.class);
    private static CustomHtmlProcessorFactory custom_instance;
    private Document document;
    private boolean bodyOccurred = false;
    private Stack<StyledTextListInfo> htmlListStack;
    private boolean insideLi;
    private boolean liStart;

    public MarkupProcessor createMarkupProcessor() {
        if (custom_instance == null) {
            custom_instance = new CustomHtmlProcessorFactory();
        }
        return custom_instance;
    }

    protected Map<AttributedCharacterIterator.Attribute, Object> getAttributes(AttributeSet attrSet) {
        Map attributes = super.getAttributes(attrSet);
        if (!attributes.containsKey(TextAttribute.WEIGHT) && this.hasHtmlTag(attrSet, HTML.Tag.STRONG)) {
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (!attributes.containsKey(TextAttribute.POSTURE) && this.hasHtmlTag(attrSet, HTML.Tag.EM)) {
            attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        return attributes;
    }

    public boolean hasHtmlTag(AttributeSet attrSet, HTML.Tag tag) {
        Enumeration<?> attrNames = attrSet.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            Object obj = attrNames.nextElement();
            if (!tag.equals(obj)) continue;
            return true;
        }
        return false;
    }

    public String convert(String srcText) {
        if (srcText.indexOf(60) < 0 && srcText.indexOf(38) < 0) {
            return srcText;
        }
        JRStyledText styledText = new JRStyledText();
        this.htmlListStack = new Stack();
        JEditorPane editorPane = new JEditorPane("text/html", srcText);
        editorPane.setEditable(false);
        this.document = editorPane.getDocument();
        this.bodyOccurred = false;
        Element root = this.document.getDefaultRootElement();
        if (root != null) {
            this.processElement(styledText, root);
        }
        styledText.setGlobalAttributes(new HashMap());
        return JRStyledTextParser.getInstance().write(styledText);
    }

    private void processElement(JRStyledText styledText, Element parentElement) {
        int i = 0;
        while (i < parentElement.getElementCount()) {
            Object object;
            Element element = parentElement.getElement(i);
            AttributeSet attrs = element.getAttributes();
            Object elementName = attrs.getAttribute("$ename");
            Object object2 = object = elementName != null ? null : attrs.getAttribute(StyleConstants.NameAttribute);
            if (object instanceof HTML.Tag) {
                HTML.Tag htmlTag = (HTML.Tag)object;
                if (htmlTag == HTML.Tag.BODY) {
                    this.bodyOccurred = true;
                    this.processElement(styledText, element);
                } else if (htmlTag == HTML.Tag.BR) {
                    styledText.append("\n");
                    int startIndex = styledText.length();
                    this.resizeRuns(styledText.getRuns(), startIndex, 1);
                    this.processElement(styledText, element);
                    styledText.addRun(new JRStyledText.Run(new HashMap(), startIndex, styledText.length()));
                    if (startIndex < styledText.length()) {
                        styledText.append("\n");
                        this.resizeRuns(styledText.getRuns(), startIndex, 1);
                    }
                } else if (htmlTag != HTML.Tag.OL && htmlTag != HTML.Tag.UL) {
                    if (htmlTag == HTML.Tag.LI) {
                        StyledTextListInfo htmlList;
                        HashMap<JRTextAttribute, Object> styleAttrs = new HashMap<JRTextAttribute, Object>();
                        boolean ulAdded = false;
                        if (this.htmlListStack.isEmpty()) {
                            htmlList = new StyledTextListInfo(false, null, null, false);
                            this.htmlListStack.push(htmlList);
                            styleAttrs.put(JRTextAttribute.HTML_LIST, this.htmlListStack.toArray(new StyledTextListInfo[this.htmlListStack.size()]));
                            styleAttrs.put(JRTextAttribute.HTML_LIST_ITEM, StyledTextListItemInfo.NO_LIST_ITEM_FILLER);
                            ulAdded = true;
                        } else {
                            htmlList = (StyledTextListInfo)this.htmlListStack.peek();
                        }
                        htmlList.setItemCount(htmlList.getItemCount() + 1);
                        this.insideLi = true;
                        this.liStart = true;
                        styleAttrs.put(JRTextAttribute.HTML_LIST_ITEM, new StyledTextListItemInfo(htmlList.getItemCount() - 1));
                        int startIndex = styledText.length();
                        this.processElement(styledText, element);
                        styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                        this.insideLi = false;
                        this.liStart = false;
                        if (ulAdded) {
                            this.htmlListStack.pop();
                        }
                    } else if (element instanceof AbstractDocument.LeafElement) {
                        String chunk = null;
                        try {
                            chunk = this.document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                        }
                        catch (BadLocationException var15) {
                            LOGGER.debug("Error converting markup.", (Throwable)var15);
                        }
                        if (chunk != null) {
                            HTMLDocument.RunElement runElement;
                            AttributeSet attrSet;
                            this.liStart = false;
                            int startIndex = styledText.length();
                            styledText.append(chunk);
                            Map styleAttributes = this.getAttributes(element.getAttributes());
                            if (element instanceof HTMLDocument.RunElement && (attrSet = (AttributeSet)(runElement = (HTMLDocument.RunElement)element).getAttribute(HTML.Tag.A)) != null) {
                                JRBasePrintHyperlink hyperlink = new JRBasePrintHyperlink();
                                hyperlink.setHyperlinkType(HyperlinkTypeEnum.REFERENCE);
                                hyperlink.setHyperlinkReference((String)attrSet.getAttribute(HTML.Attribute.HREF));
                                hyperlink.setLinkTarget((String)attrSet.getAttribute(HTML.Attribute.TARGET));
                                styleAttributes.put(JRTextAttribute.HYPERLINK, hyperlink);
                            }
                            styledText.addRun(new JRStyledText.Run(styleAttributes, startIndex, styledText.length()));
                        }
                    } else if (this.bodyOccurred) {
                        this.processElement(styledText, element);
                    }
                } else {
                    Object type = attrs.getAttribute(HTML.Attribute.TYPE);
                    Object htmlListObj = attrs.getAttribute(HTML.Attribute.START);
                    StyledTextListInfo htmlList = new StyledTextListInfo(htmlTag == HTML.Tag.OL, htmlTag == HTML.Tag.OL && type != null ? String.valueOf(type) : null, htmlTag == HTML.Tag.OL && htmlListObj != null ? Integer.valueOf(htmlListObj.toString()) : null, this.insideLi);
                    htmlList.setAtLiStart(this.liStart);
                    this.htmlListStack.push(htmlList);
                    this.insideLi = false;
                    HashMap<JRTextAttribute, Object> styleAttrs = new HashMap<JRTextAttribute, Object>();
                    styleAttrs.put(JRTextAttribute.HTML_LIST, this.htmlListStack.toArray(new StyledTextListInfo[this.htmlListStack.size()]));
                    styleAttrs.put(JRTextAttribute.HTML_LIST_ITEM, StyledTextListItemInfo.NO_LIST_ITEM_FILLER);
                    int startIndex = styledText.length();
                    this.processElement(styledText, element);
                    styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                }
            }
            ++i;
        }
        List runs = styledText.getRuns();
        for (JRStyledText.Run run : runs) {
            if (run.endIndex <= styledText.length()) continue;
            run.endIndex = styledText.length();
        }
    }

    private void resizeRuns(List<JRStyledText.Run> runs, int startIndex, int count) {
        for (JRStyledText.Run value : runs) {
            if (value.startIndex > startIndex || value.endIndex <= startIndex - count) continue;
            value.endIndex += count;
        }
    }
}

