/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm;

import jakarta.inject.Inject;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.PriorityOrdered;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.configuration.ConfigurationService;

@Component
public class PluginValidationPreProcessor
implements ApplicationListener<ApplicationReadyEvent>,
PriorityOrdered {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginValidationPreProcessor.class);
    @Inject
    private ConfigurationService configurationService;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        LOGGER.info("About to reset plugin license validation information.", new Object[0]);
        this.resetPluginLicenseInfo();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private void resetPluginLicenseInfo() {
        this.configurationService.updateConfiguration("plugin.license.expiration", "");
        this.configurationService.updateConfiguration("activated.user.excess", "");
    }
}

