/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import java.io.IOException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public class SquashResourceResolver
extends PathResourceResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashResourceResolver.class);
    private String baseApiPath = "backend";

    protected Resource getResource(String resourcePath, Resource location) throws IOException {
        LOGGER.debug("Try to resolve resource for resource : {} ", new Object[]{resourcePath});
        if (resourcePath.startsWith(this.baseApiPath) || resourcePath.startsWith("/error") || resourcePath.startsWith("error") || resourcePath.startsWith(this.baseApiPath.substring(1))) {
            LOGGER.debug("{} seems to be a call to data controllers, returning null.", new Object[]{resourcePath});
            return null;
        }
        if (resourcePath.startsWith("/plugin/") || resourcePath.startsWith("plugin/")) {
            LOGGER.debug("{} seems to be a call to plugin. Try to resolve plugin app.", new Object[]{resourcePath});
            String[] parts = resourcePath.split("/");
            ClassPathResource pluginRootPage = null;
            if (parts.length > 1) {
                LOGGER.debug("Requested plugin root page is {}", new Object[]{parts[1]});
                pluginRootPage = new ClassPathResource("/META-INF/resources/" + parts[1] + "/index.html");
                LOGGER.debug("Resolved plugin, root page : {}. class path resource is : {}.", new Object[]{parts[1], pluginRootPage});
            }
            return pluginRootPage != null && pluginRootPage.exists() && pluginRootPage.isReadable() ? pluginRootPage : null;
        }
        return location.exists() && location.isReadable() ? location : null;
    }
}

