/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import liquibase.exception.LiquibaseException;
import liquibase.integration.spring.SpringLiquibase;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.RepositoryConfig;
import org.squashtest.tm.web.exception.DatabaseConnectionException;
import org.squashtest.tm.web.exception.InvalidDbUpdateModeException;
import org.squashtest.tm.web.exception.PromptAttemptsException;
import org.squashtest.tm.web.exception.RequiredManualChangesetMissingException;
import org.squashtest.tm.web.exception.UnsupportedInteractivePromptException;

@org.springframework.context.annotation.Configuration
public class LiquibaseConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(LiquibaseConfig.class);
    private static final String V8_1_0_LAST_REQUIRED_MANUAL_CHANGESET_ID = "tm-8.1.0-replace-SSF-by-CF-in-denormalized-field-table";
    private static final Pattern POSITIVE_PATTERN = Pattern.compile("^[yY]$");
    private static final Pattern NEGATIVE_PATTERN = Pattern.compile("^[nN]$");
    private static final int MAX_ATTEMPTS = 5;
    private final Environment env;
    private final DataSource dataSource;
    private String currentDatabaseVersion;

    @Autowired
    public LiquibaseConfig(Environment env, DataSource dataSource) {
        this.env = env;
        this.dataSource = dataSource;
    }

    @Bean
    public SpringLiquibase liquibase() {
        String dbUpdateModePropertyValue = this.env.getProperty("squash.db.update-mode");
        DbUpdate dbUpdateMode = DbUpdate.fromString(dbUpdateModePropertyValue);
        this.checkDatabaseAccess();
        LiquibaseBasePerform liquibase = new LiquibaseBasePerform();
        liquibase.setDataSource(this.dataSource);
        liquibase.setChangeLog(this.env.getProperty("spring.liquibase.change-log"));
        liquibase.setShouldRun(false);
        liquibase.setDropFirst(false);
        if (DbUpdate.DISABLED.equals((Object)dbUpdateMode)) {
            return liquibase;
        }
        return this.handleDatabaseUpdate(dbUpdateMode, liquibase);
    }

    private void checkDatabaseAccess() {
        SQLException sqlException = null;
        int attempt = 0;
        while (attempt < 12) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (Connection connection = this.dataSource.getConnection();){
                    LOGGER.debug("Connection to database successful on attempt {} / ", new Object[]{attempt + 1, 12});
                    return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                sqlException = e;
                LOGGER.warn("Database connection failed on attempt {}. Retrying in {} ms...", new Object[]{attempt + 1, 5000});
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                ++attempt;
            }
        }
        LOGGER.error("Database connection failed after {} attempts. Aborting.", new Object[]{12});
        throw new DatabaseConnectionException("Error while connecting to database after multiple retries", sqlException);
    }

    private SpringLiquibase handleDatabaseUpdate(DbUpdate dbUpdateMode, SpringLiquibase liquibase) {
        Configuration jooqConfig = this.getJooqConfig();
        DSLContext dslContext = DSL.using((Configuration)jooqConfig);
        if (this.checkDatabaseChangelogTableExists(dslContext)) {
            this.handleDatabaseNotEmpty(dbUpdateMode, liquibase, dslContext);
        } else {
            liquibase.setShouldRun(true);
        }
        return liquibase;
    }

    private Configuration getJooqConfig() {
        RepositoryConfig repositoryConfig = new RepositoryConfig(this.env);
        DefaultConfiguration configuration = repositoryConfig.getJooqConfiguration();
        return configuration.set(this.dataSource);
    }

    private boolean checkDatabaseChangelogTableExists(DSLContext dslContext) {
        try {
            return dslContext.fetchExists((Table)Tables.DATABASECHANGELOG);
        }
        catch (DataAccessException e) {
            LOGGER.debug("databasechangelog table doesn't exist.", (Throwable)e);
            return false;
        }
    }

    private void handleDatabaseNotEmpty(DbUpdate dbUpdateMode, SpringLiquibase liquibase, DSLContext dslContext) {
        if (this.checkingDatabaseHasLastRequiredManualChangeset(dslContext)) {
            if (DbUpdate.INTERACTIVE.equals((Object)dbUpdateMode) && !this.databaseIsUpToDate(dslContext)) {
                this.askUserPermissionForAutoUpdate(liquibase);
            } else {
                liquibase.setLabelFilter(this.env.getProperty("spring.liquibase.label-filter"));
                liquibase.setShouldRun(true);
            }
        } else {
            throw new RequiredManualChangesetMissingException("Last required manual changeset not found. You need to update your database manually to version 8.1 (included)");
        }
    }

    private boolean databaseIsUpToDate(DSLContext dslContext) {
        this.currentDatabaseVersion = this.getDatabaseVersion(dslContext);
        return "10.0.0".equals(this.currentDatabaseVersion);
    }

    private String getDatabaseVersion(DSLContext dslContext) {
        this.currentDatabaseVersion = (String)dslContext.select((SelectField)Tables.CORE_CONFIG.VALUE).from((TableLike)Tables.CORE_CONFIG).where(Tables.CORE_CONFIG.STR_KEY.eq((Object)"squashtest.tm.database.version")).fetchOneInto(String.class);
        return this.currentDatabaseVersion;
    }

    /*
     * Unable to fully structure code
     */
    private void askUserPermissionForAutoUpdate(SpringLiquibase liquibase) {
        System.out.printf("%n%n%s%n%s%n%s%n", new Object[]{"=".repeat(20), "Database update", "=".repeat(20)});
        prompt = String.format("    ################################################################################\n    ################################################################################\n    #####                                                                      #####\n    #####   /!\\                   ACTION REQUIRED                        /!\\   #####\n    #####                                                                      #####\n    #####  >> The upgrade of the Squash database from version %s            #####\n    #####             to version %s is about to be performed.               #####\n    #####  >> Before running the update, make sure you performed a             #####\n    #####             database's backup.                                       #####\n    #####                                                                      #####\n    #####  >> Do you agree to proceed with the database upgrade (Y/N)?         #####\n    #####  >> If you answer N, the database won't be upgraded                  #####\n    #####             and Squash will stop.                                    #####\n    #####                                                                      #####\n    ################################################################################\n    ################################################################################\n", new Object[]{this.currentDatabaseVersion, "10.0.0"});
        System.out.println(prompt);
        attempts = 0;
        try {
            var4_4 = null;
            var5_7 = null;
            try {
                scanner = new Scanner(System.in);
                try {
                    while (true) {
                        System.out.printf("Enter your choice (y/n): [%d/%d attempts]%n", new Object[]{attempts + 1, 5});
                        userInput = scanner.nextLine().trim();
                        if (LiquibaseConfig.POSITIVE_PATTERN.matcher(userInput).matches()) {
                            liquibase.setLabelFilter(this.env.getProperty("spring.liquibase.labels"));
                            liquibase.setShouldRun(true);
                            System.out.println("Database update initiated.");
                            return;
                        }
                        if (LiquibaseConfig.NEGATIVE_PATTERN.matcher(userInput).matches()) {
                            System.out.println("Database update canceled.");
                            return;
                        }
                        System.out.println("Invalid input. Please enter 'y' for yes or 'n' for no.");
                        ++attempts;
                        break;
                    }
                }
                finally {
                    if (attempts < 5) ** continue;
                }
            }
            catch (Throwable var5_8) {
                if (var4_4 == null) {
                    var4_4 = var5_8;
                } else if (var4_4 != var5_8) {
                    var4_4.addSuppressed(var5_8);
                }
                throw var4_4;
            }
        }
        catch (NoSuchElementException e) {
            LiquibaseConfig.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new UnsupportedInteractivePromptException(String.format("The database needs to be updated while Squash TM has been configured with the squash.db.update-mode parameter set to \"%s\". But no console is attached to the process, so the manual input required for confirming the database update cannot be provided. Squash TM will be stopped.%nPlease, either update the value of the squash.db.update-mode parameter (in the squash.tm.cfg.properties file) to \"%s\" or \"%s\", or launch Squash TM from the command line. Refer to the Squash documentation for the details of the database automated update. Do not forget to perform a backup of your database beforehand.", new Object[]{DbUpdate.INTERACTIVE, DbUpdate.FORCED, DbUpdate.ONLY}));
        }
        throw new PromptAttemptsException("Exceeded maximum number of attempts. Operation aborted.");
    }

    private boolean checkingDatabaseHasLastRequiredManualChangeset(DSLContext dslContext) {
        return dslContext.fetchExists((Select)dslContext.select((SelectField)Tables.DATABASECHANGELOG.ID).from((TableLike)Tables.DATABASECHANGELOG).where(Tables.DATABASECHANGELOG.ID.eq((Object)V8_1_0_LAST_REQUIRED_MANUAL_CHANGESET_ID)));
    }

    public static enum DbUpdate {
        INTERACTIVE,
        ONLY,
        FORCED,
        DISABLED;


        public static DbUpdate fromString(String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return INTERACTIVE;
            }
            return Arrays.stream(DbUpdate.values()).filter(dbUpdate -> dbUpdate.name().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new InvalidDbUpdateModeException(String.format("Invalid squash.db.update-mode property: \"%s\". Valid values are: interactive, only, forced or disabled.", value)));
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    private class LiquibaseBasePerform
    extends SpringLiquibase {
        private LiquibaseBasePerform() {
        }

        public void afterPropertiesSet() throws LiquibaseException {
            super.afterPropertiesSet();
            DbUpdate dbUpdateMode = DbUpdate.fromString(LiquibaseConfig.this.env.getProperty("squash.db.update-mode"));
            if (DbUpdate.ONLY.equals((Object)dbUpdateMode)) {
                LOGGER.info("Database update mode set to 'only'. The program will now stop", new Object[0]);
                Runtime.getRuntime().halt(0);
            }
        }
    }
}

