/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public class CustomRestApiBasicAuthFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomRestApiBasicAuthFilter.class);
    private static final String BASIC_AUTH_DISALLOWED = "Basic authentication is not allowed for REST API.";
    @Value(value="${squash.rest-api.disallow-basic-authentication:#{false}}")
    private boolean disallowBasicAuth;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.disallowBasicAuth && request.getHeader("Authorization") != null && request.getHeader("Authorization").startsWith("Basic ")) {
            LOGGER.error(BASIC_AUTH_DISALLOWED, new Object[0]);
            SecurityContextHolder.clearContext();
            response.setStatus(401);
            response.setContentType("application/json");
            response.getWriter().write(BASIC_AUTH_DISALLOWED);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

