/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.security.authentication;

import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.User;
import org.squashtest.tm.api.security.authentication.AuthenticationProviderFeatures;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.internal.security.AuthenticationProviderContext;
import org.squashtest.tm.service.internal.security.InternalAuthenticationProviderFeatures;
import org.squashtest.tm.service.security.AdministratorAuthenticationService;
import org.squashtest.tm.web.backend.context.ApplicationComponent;

@ApplicationComponent
public class PasswordSchemeUpgrader
implements ApplicationListener<AuthenticationSuccessEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordSchemeUpgrader.class);
    private static final String PASSWORD_HASH_PREFIX = "{bcrypt}";
    @Inject
    private AuthenticationProviderContext authProviderContext;
    @Inject
    private AdministratorAuthenticationService authService;

    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        try {
            this.upgradePasswordIfRequired(event);
        }
        catch (Exception exception) {
            LOGGER.debug("unexpected error while checking for password scheme upgrade", (Throwable)exception);
        }
    }

    private void upgradePasswordIfRequired(AuthenticationSuccessEvent event) {
        Authentication authentication = event.getAuthentication();
        LOGGER.debug("upgrading password for user '{}' if needed", new Object[]{authentication.getName()});
        User user = this.extractUserIfExists(authentication);
        if (user == null) {
            LOGGER.trace("the principal is not a user (weird), skipping", new Object[0]);
            return;
        }
        AuthenticationProviderFeatures features = this.authProviderContext.getProviderFeatures(authentication);
        if (features != InternalAuthenticationProviderFeatures.INSTANCE) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("user logged in using provider '{}', skipping upgrade", new Object[]{features.getProviderName()});
            }
            return;
        }
        boolean needsUpgrade = this.doesRequireUpgrade(user);
        String clearPassword = this.extractClearPasswordIfExists(authentication);
        if (needsUpgrade) {
            if (clearPassword != null) {
                LOGGER.trace("password needs scheme upgrade -> upgrading", new Object[0]);
                this.authService.resetUserPassword(user.getUsername(), clearPassword);
            } else {
                LOGGER.trace("password needs scheme upgrade but password is unavailable. It must be changed manually.", new Object[0]);
            }
        }
    }

    private User extractUserIfExists(Authentication authentication) {
        Object principal = authentication.getPrincipal();
        if (principal != null && User.class.isAssignableFrom(principal.getClass())) {
            return (User)principal;
        }
        return null;
    }

    private String extractClearPasswordIfExists(Authentication authentication) {
        Object creds = authentication.getCredentials();
        if (creds != null && String.class.isAssignableFrom(creds.getClass())) {
            LOGGER.trace("password found", new Object[0]);
            return (String)creds;
        }
        return null;
    }

    private boolean doesRequireUpgrade(User user) {
        String pwd = user.getPassword();
        if (!StringUtils.isBlank((CharSequence)pwd)) {
            return !pwd.startsWith(PASSWORD_HASH_PREFIX);
        }
        return false;
    }
}

