/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.report.criteria;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.form.InputType;
import org.squashtest.tm.web.backend.report.criteria.AbstractCriteriaBase;

public final class MultiOptionsCriteria
extends AbstractCriteriaBase
implements Criteria {
    private final Map<Object, Boolean> isSelectedByOption = new HashMap<Object, Boolean>();
    private final List<Object> selectedOptions = new ArrayList<Object>();

    MultiOptionsCriteria(String name, InputType sourceInput) {
        super(name, sourceInput);
    }

    void addOption(Object optionValue, boolean selected) {
        this.isSelectedByOption.put(optionValue, selected);
        if (selected) {
            this.selectedOptions.add(optionValue);
        }
    }

    public Collection<Object> getValue() {
        return Collections.unmodifiableList(this.selectedOptions);
    }

    public Collection<Object> getSelectedOptions() {
        return this.getValue();
    }

    public boolean hasValue() {
        return true;
    }

    public boolean isSelected(String optionValue) throws IllegalArgumentException {
        Boolean res = this.isSelectedByOption.get(optionValue);
        if (res == null) {
            throw new IllegalArgumentException("'" + optionValue + "' does not belong to the known option values. Known values are : " + String.valueOf(this.isSelectedByOption.values()));
        }
        return res;
    }
}

