/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.model.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public class HtmlEscapeSerializer
extends StdSerializer<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlEscapeSerializer.class);

    public HtmlEscapeSerializer() {
        super(String.class);
    }

    public void serialize(String s, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CLEANING STRING {}", new Object[]{s});
        }
        s = HtmlUtils.htmlUnescape((String)s);
        String cleaned = HtmlUtils.htmlEscape((String)s);
        jsonGenerator.writeString(cleaned);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CLEANED STRING {}", new Object[]{cleaned});
        }
    }
}

