/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.model.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

public class CleanedStringSerializer
extends StdSerializer<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanedStringSerializer.class);

    public CleanedStringSerializer() {
        super(String.class);
    }

    public void serialize(String s, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        LOGGER.debug("CLEANING STRING {}", new Object[]{s});
        String cleaned = HTMLCleanupUtils.cleanHtml((String)s);
        jsonGenerator.writeString(cleaned);
        LOGGER.debug("CLEANED STRING {}", new Object[]{cleaned});
    }
}

