/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.model.builder;

import jakarta.inject.Inject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.chart.ChartInstance;
import org.squashtest.tm.domain.customreport.CustomReportChartBinding;
import org.squashtest.tm.service.chart.ChartModificationService;
import org.squashtest.tm.service.internal.dto.json.JsonChartInstance;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportChartBinding;

@Component(value="customReport.chartBindingBuilder")
@Scope(value="prototype")
public class JsonCustomReportChartBindingBuilder {
    private ChartModificationService chartService;
    private JsonCustomReportChartBinding json = new JsonCustomReportChartBinding();

    @Inject
    public JsonCustomReportChartBindingBuilder(ChartModificationService chartService) {
        this.chartService = chartService;
    }

    public JsonCustomReportChartBinding build(CustomReportChartBinding binding) {
        this.json.setId(binding.getId());
        this.json.setChartDefinitionId(binding.getChart().getId());
        this.json.setDashboardId(binding.getDashboard().getId());
        this.json.setCol(binding.getCol());
        this.json.setRow(binding.getRow());
        this.json.setSizeX(binding.getSizeX());
        this.json.setSizeY(binding.getSizeY());
        ChartInstance chartInstance = this.chartService.generateChart(binding.getChart(), null, binding.getDashboard().getId());
        JsonChartInstance jsonChartInstance = new JsonChartInstance(chartInstance);
        this.json.setChartInstance(jsonChartInstance);
        return this.json;
    }
}

