/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.listener;

import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public class HttpSessionLifecycleLogger
implements HttpSessionListener,
ServletRequestListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpSessionLifecycleLogger.class);

    public void requestDestroyed(ServletRequestEvent sre) {
    }

    public void requestInitialized(ServletRequestEvent sre) {
        HttpServletRequest request = (HttpServletRequest)sre.getServletRequest();
        Cookie sessionCookie = this.findSessionIdCookie(request);
        if (sessionCookie != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Received request for HTTP session id {} at {}", new Object[]{sessionCookie.getValue(), System.currentTimeMillis()});
            }
        } else {
            LOGGER.info("Received request with no session cookie : {}", new Object[]{request.getRequestURI()});
        }
    }

    private Cookie findSessionIdCookie(HttpServletRequest request) {
        if (request.getCookies() != null) {
            Cookie[] cookieArray = request.getCookies();
            int n = cookieArray.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if ("JSESSIONID".equals(cookie.getName())) {
                    return cookie;
                }
                ++n2;
            }
        }
        return null;
    }

    public void sessionCreated(HttpSessionEvent se) {
        LOGGER.info("Created a HTTP session id {} at {}", new Object[]{se.getSession().getId(), System.currentTimeMillis()});
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        LOGGER.info("Destroyed HTTP session id {} at {}", new Object[]{se.getSession().getId(), System.currentTimeMillis()});
    }
}

