/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.interceptor;

import jakarta.inject.Inject;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.WebSecurityExpressionRoot;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

@Component
public class SecurityExpressionResolverExposerInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityExpressionResolverExposerInterceptor.class);
    private static final FilterChain DUMMY_CHAIN = (request, response) -> {
        throw new UnsupportedOperationException();
    };
    @Inject
    private PermissionEvaluator permissionEvaluator;
    private final AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
        if (modelAndView != null && modelAndView.hasView() && !StringUtils.startsWith((CharSequence)modelAndView.getViewName(), (CharSequence)"redirect:")) {
            FilterInvocation filterInvocation = new FilterInvocation((ServletRequest)request, (ServletResponse)response, DUMMY_CHAIN);
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication == null) {
                LOGGER.debug("No authentication available for '{}{}'. Thymeleaf won't have access to '#sec' in view '{}'", new Object[]{request.getServletPath(), request.getPathInfo(), modelAndView.getViewName()});
                return;
            }
            WebSecurityExpressionRoot expressionRoot = new WebSecurityExpressionRoot(authentication, filterInvocation);
            expressionRoot.setTrustResolver(this.trustResolver);
            expressionRoot.setPermissionEvaluator(this.permissionEvaluator);
            modelAndView.addObject("sec", (Object)expressionRoot);
        }
    }
}

