/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.filter.xss;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.owasp.encoder.esapi.ESAPIEncoder;
import org.owasp.esapi.errors.IntrusionException;

public class XSSRequestWrapper
extends HttpServletRequestWrapper {
    private static final String USER_FACING_MESSAGE = "Intrusion detected";
    private static final String HEADER_REFERER = "referer";

    public XSSRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public Map<String, String[]> getParameterMap() {
        Map parameterMap = super.getParameterMap();
        if (Objects.isNull(parameterMap)) {
            return null;
        }
        parameterMap.values().forEach(this::stripXSS);
        return parameterMap;
    }

    public String[] getParameterValues(String name) {
        String[] parameterValues = super.getParameterValues(name);
        if (Objects.isNull(parameterValues)) {
            return null;
        }
        this.stripXSS(parameterValues);
        return parameterValues;
    }

    public String getParameter(String name) {
        String parameterValue = super.getParameter(name);
        this.doStripXSS(parameterValue, StripOptions.STRICT);
        return parameterValue;
    }

    public Enumeration<String> getHeaders(String name) {
        Enumeration headers = super.getHeaders(name);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            String[] stringArray = tokens = header.split(",");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                this.stripHeaderXSS(name, token);
                ++n2;
            }
        }
        return super.getHeaders(name);
    }

    public String getHeader(String name) {
        String header = super.getHeader(name);
        this.stripHeaderXSS(name, header);
        return header;
    }

    public Cookie[] getCookies() {
        Cookie[] cookies = super.getCookies();
        if (cookies == null) {
            return cookies;
        }
        List<Cookie> filteredCookies = Arrays.stream(cookies).filter(cookie -> !this.isThirdPartyCookie((Cookie)cookie)).toList();
        filteredCookies.forEach(cookie -> this.doStripXSS(cookie.getValue(), StripOptions.STRICT));
        return filteredCookies.toArray(new Cookie[0]);
    }

    private boolean isThirdPartyCookie(Cookie cookie) {
        String requestDomain = super.getServerName();
        String cookieDomain = cookie.getDomain();
        if (cookieDomain == null) {
            return false;
        }
        return !cookieDomain.equals(requestDomain) && !cookieDomain.endsWith("." + requestDomain);
    }

    private void stripHeaderXSS(String headerName, String value) {
        if ("Cookie".equals(headerName)) {
            return;
        }
        if (headerName.equals(HEADER_REFERER)) {
            this.doStripXSS(value, StripOptions.ALLOW_MIXED_ENCODING);
        } else {
            this.stripXSS(value);
        }
    }

    private void stripXSS(String[] values) {
        Arrays.stream(values).forEach(this::stripXSS);
    }

    private void stripXSS(String value) {
        this.doStripXSS(value, StripOptions.STRICT);
    }

    private void doStripXSS(String value, StripOptions options) {
        if (value == null) {
            return;
        }
        String canonicalValue = ESAPIEncoder.getInstance().canonicalize(value, options.restrictMultiple, options.restrictMixed).replace("\u0000", "").trim();
        boolean valid = Jsoup.isValid((String)canonicalValue, (Safelist)Safelist.none());
        if (!valid) {
            String message = "Found a potential XSS attack in value %s. The canonical value is %s".formatted(value, canonicalValue);
            throw new IntrusionException(USER_FACING_MESSAGE, message);
        }
    }

    private static enum StripOptions {
        STRICT(true, true),
        ALLOW_MIXED_ENCODING(true, false);

        final boolean restrictMultiple;
        final boolean restrictMixed;

        private StripOptions(boolean restrictMultiple, boolean restrictMixed) {
            this.restrictMultiple = restrictMultiple;
            this.restrictMixed = restrictMixed;
        }
    }
}

