/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public class UserConcurrentRequestLockFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserConcurrentRequestLockFilter.class);
    public static final String READ_WRITE_LOCK_SESSION_KEY = "squashtest.core.ReadWriteLock";
    public static final String READ_REQUEST = "READ request : ";
    public static final String WRITE_REQUEST = "WRITE request : ";
    private String excludePatterns;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.excludePatterns = filterConfig.getInitParameter("excludePatterns");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String url = req.getServletPath() + StringUtils.defaultString((String)req.getPathInfo());
        if (!this.matchExcludePatterns(url)) {
            ReadWriteLock lock = this.loadLock(request);
            try {
                this.handleRequest(request, response, chain, lock);
            }
            finally {
                this.storeLockInExistingSession(request, lock);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean matchExcludePatterns(String url) {
        boolean result = false;
        if (this.excludePatterns != null) {
            Pattern p = Pattern.compile(this.excludePatterns);
            Matcher m = p.matcher(url);
            result = m.matches();
        }
        return result;
    }

    private void handleRequest(ServletRequest request, ServletResponse response, FilterChain chain, ReadWriteLock lock) throws IOException, ServletException {
        if (this.isWriteRequest(request)) {
            this.handleWriteRequest(request, response, chain, lock);
        } else {
            this.handleReadRequest(request, response, chain, lock);
        }
    }

    private void handleReadRequest(ServletRequest request, ServletResponse response, FilterChain chain, ReadWriteLock lock) throws IOException, ServletException {
        HttpServletRequest hrequest;
        if (LOGGER.isDebugEnabled()) {
            hrequest = (HttpServletRequest)request;
            LOGGER.debug(READ_REQUEST + hrequest.getMethod() + " " + hrequest.getRequestURI() + " : attempting to acquire lock", new Object[0]);
        }
        lock.readLock().lock();
        try {
            if (LOGGER.isDebugEnabled()) {
                hrequest = (HttpServletRequest)request;
                LOGGER.debug(READ_REQUEST + hrequest.getMethod() + " " + hrequest.getRequestURI() + " : lock acquired", new Object[0]);
            }
            chain.doFilter(request, response);
        }
        finally {
            lock.readLock().unlock();
            if (LOGGER.isDebugEnabled()) {
                HttpServletRequest hrequest2 = (HttpServletRequest)request;
                LOGGER.debug(READ_REQUEST + hrequest2.getMethod() + " " + hrequest2.getRequestURI() + " : lock released", new Object[0]);
            }
        }
    }

    private void handleWriteRequest(ServletRequest request, ServletResponse response, FilterChain chain, ReadWriteLock lock) throws IOException, ServletException {
        HttpServletRequest hrequest;
        if (LOGGER.isDebugEnabled()) {
            hrequest = (HttpServletRequest)request;
            LOGGER.debug(WRITE_REQUEST + hrequest.getMethod() + " " + hrequest.getRequestURI() + " : attempting to acquire lock", new Object[0]);
        }
        lock.writeLock().lock();
        try {
            if (LOGGER.isDebugEnabled()) {
                hrequest = (HttpServletRequest)request;
                LOGGER.debug(WRITE_REQUEST + hrequest.getMethod() + " " + hrequest.getRequestURI() + " : lock acquired", new Object[0]);
            }
            chain.doFilter(request, response);
        }
        finally {
            lock.writeLock().unlock();
            if (LOGGER.isDebugEnabled()) {
                HttpServletRequest hrequest2 = (HttpServletRequest)request;
                LOGGER.debug(WRITE_REQUEST + hrequest2.getMethod() + " " + hrequest2.getRequestURI() + " : lock released", new Object[0]);
            }
        }
    }

    private boolean isWriteRequest(ServletRequest request) {
        String httpMethod = ((HttpServletRequest)request).getMethod();
        return "POST".equals(httpMethod) || "DELETE".equals(httpMethod) || "PUT".equals(httpMethod);
    }

    private void storeLockInExistingSession(ServletRequest request, ReadWriteLock context) {
        HttpSession session = ((HttpServletRequest)request).getSession(false);
        if (session == null) {
            LOGGER.debug("Session was invalidated, ReadWriteLock will not be stored", new Object[0]);
            return;
        }
        this.storeLock(session, context);
        LOGGER.trace("ReadWriteLock stored to session", new Object[0]);
    }

    private void storeLock(HttpSession session, ReadWriteLock lock) {
        session.setAttribute(READ_WRITE_LOCK_SESSION_KEY, (Object)lock);
    }

    private ReadWriteLock loadLock(ServletRequest request) {
        LOGGER.trace("Loading ReadWriteLock from HTTP session", new Object[0]);
        HttpSession session = ((HttpServletRequest)request).getSession();
        ReadWriteLock lock = (ReadWriteLock)session.getAttribute(READ_WRITE_LOCK_SESSION_KEY);
        if (lock == null) {
            LOGGER.debug("No ReadWriteLock available, will create it and eagerly store it in session", new Object[0]);
            lock = new ReentrantReadWriteLock();
            this.storeLock(session, lock);
        }
        return lock;
    }

    public void destroy() {
    }
}

