/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.exceptionresolver;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.ConstraintViolationException;
import java.util.List;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.web.backend.exceptionresolver.model.FieldValidationErrorModel;
import org.squashtest.tm.web.backend.exceptionresolver.model.SquashFieldValidationErrorModel;

@ControllerAdvice
public class HandlerTransactionSystemExceptionResolver
extends AbstractHandlerExceptionResolver {
    @ExceptionHandler(value={TransactionSystemException.class})
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex)) {
            response.setStatus(412);
            ConstraintViolationException bex = (ConstraintViolationException)ex.getCause().getCause();
            List<FieldValidationErrorModel> errors = this.buildFieldValidationErrors(bex);
            SquashFieldValidationErrorModel squashError = new SquashFieldValidationErrorModel(errors);
            return new ModelAndView((View)new MappingJackson2JsonView(), "squashTMError", (Object)squashError);
        }
        return null;
    }

    private List<FieldValidationErrorModel> buildFieldValidationErrors(ConstraintViolationException constraintViolationException) {
        return constraintViolationException.getConstraintViolations().stream().map(constraintViolation -> new FieldValidationErrorModel("", constraintViolation.getPropertyPath().toString(), constraintViolation.getMessage())).toList();
    }

    private boolean exceptionIsHandled(Exception ex) {
        Throwable rootCause;
        Throwable throwable = rootCause = ex.getCause() != null && ex.getCause().getCause() != null ? ex.getCause().getCause() : null;
        if (rootCause == null) {
            return false;
        }
        return rootCause instanceof ConstraintViolationException;
    }
}

