/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.exceptionresolver;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.web.backend.exceptionresolver.DeprecatedFieldValidationErrorModel;
import org.squashtest.tm.web.backend.exceptionresolver.ExceptionResolverUtils;
import org.squashtest.tm.web.backend.exceptionresolver.MimeType;

@ControllerAdvice
public class HandlerBindExceptionResolver
extends AbstractHandlerExceptionResolver {
    @ExceptionHandler(value={BindException.class})
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex) && ExceptionResolverUtils.clientAcceptsMIMEOrAnything(request, MimeType.APPLICATION_JSON)) {
            response.setStatus(412);
            BindException bex = (BindException)ex;
            List<DeprecatedFieldValidationErrorModel> errors = this.buildFieldValidationErrors(bex);
            return new ModelAndView((View)new MappingJackson2JsonView(), "fieldValidationErrors", errors);
        }
        return null;
    }

    private List<DeprecatedFieldValidationErrorModel> buildFieldValidationErrors(BindException bex) {
        ArrayList<DeprecatedFieldValidationErrorModel> ves = new ArrayList<DeprecatedFieldValidationErrorModel>();
        List oes = bex.getFieldErrors();
        for (FieldError oe : oes) {
            ves.add(new DeprecatedFieldValidationErrorModel(oe.getObjectName(), oe.getField(), oe.getDefaultMessage()));
        }
        return ves;
    }

    private boolean exceptionIsHandled(Exception ex) {
        return ex instanceof BindException;
    }
}

