/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.exceptionresolver;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.web.backend.exceptionresolver.MimeType;

public final class ExceptionResolverUtils {
    private ExceptionResolverUtils() {
    }

    public static boolean clientAcceptsMIME(HttpServletRequest request, MimeType type) {
        Enumeration e = request.getHeaders("Accept");
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            if (!StringUtils.containsIgnoreCase((CharSequence)StringUtils.trimToEmpty((String)header), (CharSequence)type.requestHeaderValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean clientAcceptsMIMEOrAnything(HttpServletRequest request, MimeType type) {
        Enumeration e = request.getHeaders("Accept");
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            if (!StringUtils.containsIgnoreCase((CharSequence)StringUtils.trimToEmpty((String)header), (CharSequence)type.requestHeaderValue()) && !StringUtils.containsIgnoreCase((CharSequence)StringUtils.trimToEmpty((String)header), (CharSequence)MimeType.ANYTHING.requestHeaderValue())) continue;
            return true;
        }
        return false;
    }
}

