/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.tf;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.tf.AutomationTesterRequestDisplayService;
import org.squashtest.tm.service.display.tf.AutomationWorkspaceDataProviderService;
import org.squashtest.tm.service.internal.display.dto.tf.AutomationTesterWorkspaceDataDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;

@RestController
@RequestMapping(value={"backend/automation-tester-workspace"})
public class AutomationTesterWorkspaceController {
    private final AutomationTesterRequestDisplayService automationTesterRequestDisplayService;
    private final AutomationWorkspaceDataProviderService automationWorkspaceDataProviderService;

    public AutomationTesterWorkspaceController(AutomationTesterRequestDisplayService automationTesterRequestDisplayService, AutomationWorkspaceDataProviderService automationWorkspaceDataProviderService) {
        this.automationTesterRequestDisplayService = automationTesterRequestDisplayService;
        this.automationWorkspaceDataProviderService = automationWorkspaceDataProviderService;
    }

    @GetMapping(value={"data"})
    public AutomationTesterWorkspaceDataDto getWorkspaceRefData() {
        return this.automationWorkspaceDataProviderService.findFunctionalTesterData();
    }

    @PostMapping(value={"global-view"})
    public GridResponse getAutomationRequestForGlobalView(@RequestBody GridRequest request) {
        return this.automationTesterRequestDisplayService.findGlobalView(request);
    }

    @PostMapping(value={"ready-for-transmission"})
    public GridResponse getAutomationRequestForReadyView(@RequestBody GridRequest request) {
        return this.automationTesterRequestDisplayService.findReadyForTransmissionRequests(request);
    }

    @PostMapping(value={"to-be-validated"})
    public GridResponse getAutomationRequestForValidateView(@RequestBody GridRequest request) {
        return this.automationTesterRequestDisplayService.findToBeValidatedRequests(request);
    }
}

