/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testplan;

import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.campaign.SprintTestPlanItemManagerService;
import org.squashtest.tm.service.display.testplan.SprintTestPlanDisplayService;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;

@RestController
@RequestMapping(value={"/backend"})
public class SprintTestPlanController {
    private final SprintTestPlanDisplayService sprintTestPlanDisplayService;
    private final SprintTestPlanItemManagerService sprintTestPlanItemManagerService;

    public SprintTestPlanController(SprintTestPlanDisplayService sprintTestPlanDisplayService, SprintTestPlanItemManagerService sprintTestPlanItemManagerService) {
        this.sprintTestPlanDisplayService = sprintTestPlanDisplayService;
        this.sprintTestPlanItemManagerService = sprintTestPlanItemManagerService;
    }

    @PostMapping(value={"/test-plan/{testPlanId}"})
    GridResponse findSprintTestPlan(@PathVariable Long testPlanId, @RequestBody GridRequest gridRequest) {
        return this.sprintTestPlanDisplayService.findSprintReqVersionTestPlan(testPlanId, gridRequest);
    }

    @DeleteMapping(value={"/sprint-req-version/{sprintReqVersionId}/test-plan-items/{testPlanItemIds}"})
    public void deleteItems(@PathVariable Long sprintReqVersionId, @PathVariable List<Long> testPlanItemIds) {
        this.sprintTestPlanItemManagerService.deleteSprintReqVersionTestPlanItems(sprintReqVersionId, testPlanItemIds);
    }

    @PostMapping(value={"sprint-req-version/{sprintReqVersionId}/test-plan-items/{testPlanItemIds}/position/{position}"})
    public void moveSprintReqVersionTestPlanItems(@PathVariable long sprintReqVersionId, @PathVariable List<Long> testPlanItemIds, @PathVariable int position) {
        this.sprintTestPlanItemManagerService.moveSprintReqVersionTestPlanItems(sprintReqVersionId, testPlanItemIds, position);
    }
}

