/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase.steps;

import java.util.Objects;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bdd.Keyword;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.internal.display.testcase.parameter.TestCaseParameterOperationReport;
import org.squashtest.tm.service.internal.display.testcase.teststep.TestStepActionWordOperationReport;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.service.testcase.TestStepModificationService;
import org.squashtest.tm.web.backend.controller.testcase.steps.KeywordStepUpdateModel;
import org.squashtest.tm.web.backend.controller.testcase.steps.TestStepUpdateFormModel;

@RestController
@RequestMapping(value={"backend/test-steps/{testStepId}"})
public class TestStepModificationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestStepModificationController.class);
    private final TestStepModificationService testStepService;
    private final TestCaseModificationService testCaseModificationService;
    private final TestCaseDisplayService testCaseDisplayService;

    public TestStepModificationController(TestStepModificationService testStepService, TestCaseDisplayService testCaseDisplayService, TestCaseModificationService testCaseModificationService) {
        this.testStepService = testStepService;
        this.testCaseDisplayService = testCaseDisplayService;
        this.testCaseModificationService = testCaseModificationService;
    }

    @PostMapping(headers={"Content-Type=application/json"})
    public TestCaseParameterOperationReport updateStep(@PathVariable Long testStepId, @RequestBody TestStepUpdateFormModel testStepModel) {
        this.testStepService.updateTestStep(testStepId, testStepModel.getAction(), testStepModel.getExpectedResult(), testStepModel.getCufs());
        return this.testCaseDisplayService.findParametersDataByTestStepId(testStepId);
    }

    @PostMapping(value={"/keyword"})
    public void changeStepKeyword(@PathVariable long testStepId, @RequestBody KeywordStepUpdateModel testStepModel) {
        Keyword updatedKeyword = Keyword.valueOf((String)testStepModel.getKeyword());
        this.testStepService.updateKeywordTestStep(testStepId, updatedKeyword);
        LOGGER.trace("TestCaseModificationController : updated keyword for step {}", new Object[]{testStepId});
    }

    @PostMapping(value={"/action-word"})
    public TestStepActionWordOperationReport changeStepActionWord(@PathVariable long testStepId, @RequestBody KeywordStepUpdateModel testStepModel) {
        LOGGER.trace("TestCaseModificationController : updated action word for step {}", new Object[]{testStepId});
        if (Objects.isNull(testStepModel.getActionWordId())) {
            return this.testCaseModificationService.updateKeywordTestStep(testStepId, testStepModel.getAction());
        }
        LOGGER.trace("TestCaseModificationController : updated action word for step {} with action word id {}", new Object[]{testStepId, testStepModel.getActionWordId()});
        return this.testCaseModificationService.updateKeywordTestStep(testStepId, testStepModel.getAction(), testStepModel.getActionWordId().longValue());
    }

    @PostMapping(value={"/datatable"})
    public void changeDatatable(@PathVariable long testStepId, @RequestBody KeywordStepUpdateModel testStepModel) {
        this.testCaseModificationService.updateKeywordTestStepDatatable(testStepId, testStepModel.getDatatable());
        LOGGER.trace("TestCaseModificationController : updated datatable for step {}", new Object[]{testStepId});
    }

    @PostMapping(value={"/docstring"})
    public void changeDocstring(@PathVariable long testStepId, @RequestBody KeywordStepUpdateModel testStepModel) {
        this.testCaseModificationService.updateKeywordTestStepDocstring(testStepId, testStepModel.getDocstring());
        LOGGER.trace("TestCaseModificationController : updated docstring for step {}", new Object[]{testStepId});
    }

    @PostMapping(value={"/comment"})
    public void changeComment(@PathVariable long testStepId, @RequestBody KeywordStepUpdateModel testStepModel) {
        this.testCaseModificationService.updateKeywordTestStepComment(testStepId, testStepModel.getComment());
        LOGGER.trace("TestCaseModificationController : updated comment for step {}", new Object[]{testStepId});
    }
}

