/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase.steps;

import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class KeywordTestStepModel {
    private String keyword;
    private String actionWord;
    private int index;
    private Long actionWordId;

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getActionWord() {
        return this.actionWord;
    }

    public void setActionWord(String actionWord) {
        this.actionWord = actionWord;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Long getActionWordId() {
        return this.actionWordId;
    }

    public void setActionWordId(Long actionWordId) {
        this.actionWordId = actionWordId;
    }

    public static class KeywordTestStepModelValidator
    implements Validator {
        private static final String MESSAGE_NOT_BLANK = "message.notBlank";
        private static final String MESSAGE_NOT_NULL = "message.notNull";
        private MessageSource messageSource;

        public KeywordTestStepModelValidator(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public MessageSource getMessageSource() {
            return this.messageSource;
        }

        public void setMessageSource(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public boolean supports(Class<?> aClass) {
            return aClass.equals(KeywordTestStepModel.class);
        }

        public void validate(Object target, Errors errors) {
            Locale locale = LocaleContextHolder.getLocale();
            String notBlank = this.messageSource.getMessage(MESSAGE_NOT_BLANK, null, locale);
            String notNull = this.messageSource.getMessage(MESSAGE_NOT_NULL, null, locale);
            KeywordTestStepModel model = (KeywordTestStepModel)target;
            String keyword = model.getKeyword();
            String actionWord = model.getActionWord();
            if (keyword == null) {
                errors.rejectValue("keyword", MESSAGE_NOT_NULL, notNull);
            } else if (keyword.isEmpty()) {
                errors.rejectValue("keyword", MESSAGE_NOT_BLANK, notBlank);
            }
            if (actionWord == null) {
                errors.rejectValue("actionWord", MESSAGE_NOT_NULL, notNull);
            } else if (actionWord.isEmpty()) {
                errors.rejectValue("actionWord", MESSAGE_NOT_BLANK, notBlank);
            }
        }
    }
}

