/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase.parameters;

import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.service.display.dataset.DatasetDisplayService;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.internal.display.dto.testcase.DataSetDto;
import org.squashtest.tm.service.internal.display.testcase.parameter.NewDatasetData;
import org.squashtest.tm.service.internal.display.testcase.parameter.TestCaseParameterOperationReport;
import org.squashtest.tm.service.testcase.DatasetModificationService;
import org.squashtest.tm.service.testcase.ParameterFinder;

@RestController
@RequestMapping(value={"backend/test-cases"})
public class TestCaseDataSetController {
    private final DatasetModificationService datasetModificationService;
    private final ParameterFinder parameterFinder;
    private final TestCaseDisplayService testCaseDisplayService;
    private final DatasetDisplayService datasetDisplayService;

    public TestCaseDataSetController(DatasetModificationService datasetModificationService, ParameterFinder parameterFinder, TestCaseDisplayService testCaseDisplayService, DatasetDisplayService datasetDisplayService) {
        this.datasetModificationService = datasetModificationService;
        this.parameterFinder = parameterFinder;
        this.testCaseDisplayService = testCaseDisplayService;
        this.datasetDisplayService = datasetDisplayService;
    }

    @GetMapping(value={"/{testCaseId}/datasets"})
    public List<DataSetDto> getAvailableDatasets(@PathVariable Long testCaseId) {
        return this.datasetDisplayService.findAllByTestCaseId(testCaseId);
    }

    @PostMapping(value={"/{testCaseId}/datasets/new"})
    public TestCaseParameterOperationReport newDataset(@PathVariable long testCaseId, @RequestBody NewDatasetData dataset) {
        try {
            this.datasetModificationService.persist(dataset.createDataSet(this.parameterFinder), testCaseId);
        }
        catch (DuplicateNameException ex) {
            throw new NameAlreadyInUseException("Dataset", dataset.getName(), (Exception)((Object)ex));
        }
        return this.testCaseDisplayService.findParametersData(Long.valueOf(testCaseId));
    }
}

