/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase.parameters;

import java.util.HashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.internal.display.testcase.parameter.TestCaseParameterRenameOperationReport;
import org.squashtest.tm.service.testcase.ParameterFinder;
import org.squashtest.tm.service.testcase.ParameterModificationService;
import org.squashtest.tm.web.backend.controller.testcase.parameters.ParameterPatch;

@RestController
@RequestMapping(value={"backend/parameters"})
public class ParameterController {
    private static final String PARAMETER_ID_URL = "/{parameterId}";
    private static final String PARAMETER_USED = "PARAMETER_USED";
    private final ParameterModificationService parameterService;
    private final TestCaseDisplayService testCaseDisplayService;
    private final ParameterFinder parameterFinder;

    public ParameterController(ParameterModificationService parameterService, TestCaseDisplayService testCaseDisplayService, ParameterFinder parameterFinder) {
        this.parameterService = parameterService;
        this.testCaseDisplayService = testCaseDisplayService;
        this.parameterFinder = parameterFinder;
    }

    @GetMapping(value={"/{parameterId}/used"})
    public Map<String, Boolean> isUsedParameter(@PathVariable Long parameterId) {
        HashMap<String, Boolean> used = new HashMap<String, Boolean>();
        used.put(PARAMETER_USED, this.parameterService.isUsed(parameterId.longValue()));
        return used;
    }

    @DeleteMapping(value={"/{parameterId}"})
    public void removeParameter(@PathVariable Long parameterId) {
        this.parameterService.removeById(parameterId.longValue());
    }

    @PostMapping(value={"/{parameterId}/rename"})
    public TestCaseParameterRenameOperationReport renameParameter(@PathVariable Long parameterId, @RequestBody ParameterPatch patch) {
        try {
            this.parameterService.changeName(parameterId.longValue(), patch.getName());
            Parameter parameter = this.parameterFinder.findById(parameterId.longValue());
            return new TestCaseParameterRenameOperationReport(this.testCaseDisplayService.findTestStepsByTestCaseId(parameter.getTestCase().getId()), parameter.getTestCase().getPrerequisite());
        }
        catch (DuplicateNameException ex) {
            throw new NameAlreadyInUseException("Parameter", patch.getName(), (Exception)((Object)ex));
        }
    }

    @PostMapping(value={"/{parameterId}/description"})
    public void changeDescription(@PathVariable Long parameterId, @RequestBody ParameterPatch patch) {
        this.parameterService.changeDescription(parameterId.longValue(), patch.getDescription());
    }
}

