/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase.keyword;

import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.actionword.ActionWordService;
import org.squashtest.tm.service.testcase.bdd.KeywordTestCaseService;
import org.squashtest.tm.web.backend.controller.form.model.ActionList;
import org.squashtest.tm.web.backend.controller.form.model.ScriptPreviewModel;
import org.squashtest.tm.web.backend.controller.testcase.keyword.ActionWordAutocompleteInput;

@RestController
@RequestMapping(value={"backend/keyword-test-cases"})
public class KeywordTestCaseController {
    private final ActionWordService actionWordService;
    private final KeywordTestCaseService keywordTestCaseService;

    @Autowired
    public KeywordTestCaseController(Optional<ActionWordService> actionWordService, KeywordTestCaseService keywordTestCaseService) {
        this.actionWordService = actionWordService.orElse(null);
        this.keywordTestCaseService = keywordTestCaseService;
    }

    @PostMapping(value={"/autocomplete"})
    public ActionList findAllMatchingActionWords(@RequestBody ActionWordAutocompleteInput input) {
        return new ActionList(Lists.newArrayList((Iterable)this.getActionWordService().findAllMatchingActionWords(input.getProjectId().longValue(), input.getSearchInput(), input.getSelectedProjectsIds())));
    }

    @PostMapping(value={"/duplicated-action"})
    public Map<String, Long> findAllDuplicatedActionWithProject(@RequestBody ActionWordAutocompleteInput input) {
        return this.getActionWordService().findAllDuplicatedActionWithProject(input.getProjectId().longValue(), input.getSearchInput());
    }

    @RequestMapping(value={"/{testCaseId}/generated-script"})
    public ScriptPreviewModel getGeneratedScript(@PathVariable long testCaseId) {
        return new ScriptPreviewModel(this.keywordTestCaseService.writeScriptFromTestCase(testCaseId, false));
    }

    private ActionWordService getActionWordService() {
        if (Objects.isNull(this.actionWordService)) {
            throw new AccessDeniedException("A dedicated plugin is required to manage action words.");
        }
        return this.actionWordService;
    }
}

