/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase.exploratory;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.testcase.exploratory.ExploratoryTestCaseService;

@RestController
@RequestMapping(value={"backend/test-case/{testCaseId}"})
public class ExploratoryTestCaseController {
    private final ExploratoryTestCaseService exploratoryTestCaseService;

    public ExploratoryTestCaseController(ExploratoryTestCaseService exploratoryTestCaseService) {
        this.exploratoryTestCaseService = exploratoryTestCaseService;
    }

    @PostMapping(path={"/charter"})
    public void updateTestCaseCharter(@PathVariable long testCaseId, @RequestBody ExploratoryTestCasePatch exploratoryTestCasePatch) {
        this.exploratoryTestCaseService.updateCharter(testCaseId, exploratoryTestCasePatch.getCharter());
    }

    @PostMapping(path={"/session-duration"})
    public void updateTestCaseSessionDuration(@PathVariable long testCaseId, @RequestBody ExploratoryTestCasePatch exploratoryTestCasePatch) {
        this.exploratoryTestCaseService.updateSessionDuration(testCaseId, exploratoryTestCasePatch.getDurationInMinutes());
    }

    public static class ExploratoryTestCasePatch {
        private String charter;
        private int durationInMinutes;

        public String getCharter() {
            return this.charter;
        }

        public void setCharter(String charter) {
            this.charter = charter;
        }

        public int getDurationInMinutes() {
            return this.durationInMinutes;
        }

        public void setDurationInMinutes(int durationInMinutes) {
            this.durationInMinutes = durationInMinutes;
        }
    }
}

