/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.internal.display.dto.AutomationRequestDto;
import org.squashtest.tm.service.internal.display.testcase.parameter.TestCaseParameterOperationReport;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.service.tf.AutomationRequestModificationService;

@RestController
@RequestMapping(value={"backend/test-case/{testCaseId}"})
public class TestCaseViewModificationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseViewModificationController.class);
    private final TestCaseModificationService testCaseModificationService;
    private final AutomationRequestModificationService automationRequestModificationService;
    private final TestCaseDisplayService testCaseDisplayService;

    public TestCaseViewModificationController(TestCaseModificationService testCaseModificationService, AutomationRequestModificationService automationRequestModificationService, TestCaseDisplayService testCaseDisplayService) {
        this.testCaseModificationService = testCaseModificationService;
        this.automationRequestModificationService = automationRequestModificationService;
        this.testCaseDisplayService = testCaseDisplayService;
    }

    @PostMapping(value={"/importance"})
    public void changeImportance(@PathVariable long testCaseId, @RequestBody TestCasePatch patch) {
        this.testCaseModificationService.changeImportance(testCaseId, TestCaseImportance.valueOf((String)patch.getImportance()));
    }

    @PostMapping(value={"/name"})
    public void changeName(@PathVariable long testCaseId, @RequestBody TestCasePatch patch) {
        this.testCaseModificationService.rename(testCaseId, patch.getName());
    }

    @PostMapping(value={"/reference"})
    public void changeReference(@PathVariable long testCaseId, @RequestBody TestCasePatch patch) {
        this.testCaseModificationService.changeReference(testCaseId, patch.getReference());
    }

    @PostMapping(value={"/status"})
    public void changeStatus(@PathVariable long testCaseId, @RequestBody TestCasePatch patch) {
        this.testCaseModificationService.changeStatus(testCaseId, TestCaseStatus.valueOf((String)patch.getStatus()));
    }

    @PostMapping(value={"/importance-auto"})
    public Map<String, String> changeImportanceAuto(@PathVariable long testCaseId, @RequestBody TestCasePatch patch) {
        this.testCaseModificationService.changeImportanceAuto(testCaseId, patch.isImportanceAuto());
        TestCase testCase = this.testCaseModificationService.findById(testCaseId);
        HashMap<String, String> testCaseImportance = new HashMap<String, String>();
        testCaseImportance.put("importance", testCase.getImportance().name());
        return testCaseImportance;
    }

    @PostMapping(value={"/nature"})
    public void changeNature(@PathVariable long testCaseId, @RequestBody TestCasePatch patch) {
        this.testCaseModificationService.changeNature(testCaseId, patch.getNature().longValue());
    }

    @PostMapping(value={"/type"})
    public void changeType(@PathVariable long testCaseId, @RequestBody TestCasePatch patch) {
        this.testCaseModificationService.changeType(testCaseId, patch.getType().longValue());
    }

    @PostMapping(value={"/description"})
    public void changeDescription(@RequestBody TestCasePatch patch, @PathVariable long testCaseId) {
        this.testCaseModificationService.changeDescription(testCaseId, patch.getDescription());
    }

    @PostMapping(value={"/milestones/{milestoneIds}"})
    public void bindMilestones(@PathVariable long testCaseId, @PathVariable(value="milestoneIds") List<Long> milestoneIds) {
        this.testCaseModificationService.bindMilestones(testCaseId, milestoneIds);
    }

    @DeleteMapping(value={"/milestones/{milestoneIds}"})
    public void unbindMilestones(@PathVariable long testCaseId, @PathVariable List<Long> milestoneIds) {
        this.testCaseModificationService.unbindMilestones(testCaseId, milestoneIds);
    }

    @PostMapping(value={"/automatable"})
    public AutomationRequestDto changeAutomatable(@RequestBody TestCasePatch patch, @PathVariable long testCaseId) {
        return this.testCaseModificationService.changeAutomatable(TestCaseAutomatable.valueOf((String)patch.getAutomatable()), Long.valueOf(testCaseId));
    }

    @PostMapping(value={"/prerequisite"})
    public TestCaseParameterOperationReport changePrerequisite(@PathVariable long testCaseId, @RequestBody TestCasePatch patch) {
        this.testCaseModificationService.changePrerequisite(testCaseId, patch.getPrerequisite());
        LOGGER.trace("test case {}: updated prerequisite to {}", new Object[]{testCaseId, patch.getPrerequisite()});
        return this.testCaseDisplayService.findParametersData(Long.valueOf(testCaseId));
    }

    @PostMapping(value={"/automation-request/priority"})
    public void changeAutomationRequestPriority(@RequestBody Map<String, Integer> request, @PathVariable long testCaseId) {
        this.automationRequestModificationService.changePriority(Collections.singletonList(testCaseId), request.get("priority"));
    }

    @PostMapping(value={"/scm-repository-id"})
    public void changeScmRepository(@RequestBody TestCasePatch testCasePatch, @PathVariable long testCaseId) {
        if (testCasePatch.getScmRepositoryId() == null || testCasePatch.getScmRepositoryId().equals(0L)) {
            this.testCaseModificationService.unbindSourceCodeRepository(testCaseId);
        } else {
            String newScmRepositoryUrl = this.testCaseModificationService.changeSourceCodeRepository(testCaseId, testCasePatch.getScmRepositoryId().longValue());
            LOGGER.trace("Test case {}: updated git repository to {}", new Object[]{testCaseId, newScmRepositoryUrl});
        }
    }

    @PostMapping(value={"/automated-test-technology"})
    public void changeAutomatedTestTechnology(@RequestBody TestCasePatch testCasePatch, @PathVariable long testCaseId) {
        if (testCasePatch.getAutomatedTestTechnology() != null) {
            this.testCaseModificationService.changeAutomatedTestTechnology(testCaseId, testCasePatch.getAutomatedTestTechnology().longValue());
        } else {
            this.testCaseModificationService.unbindAutomatedTestTechnology(testCaseId);
        }
    }

    @PostMapping(value={"/automated-test-reference"})
    public void changeAutomatedTestReference(@RequestBody TestCasePatch testCasePatch, @PathVariable long testCaseId) {
        this.testCaseModificationService.changeAutomatedTestReference(testCaseId, testCasePatch.getAutomatedTestReference());
    }

    static class TestCasePatch {
        private String name;
        private String reference;
        private String description;
        private String prerequisite;
        private String importance;
        private String status;
        private String automatable;
        private Long nature;
        private Long type;
        private boolean importanceAuto;
        private Long scmRepositoryId;
        private Long automatedTestTechnology;
        private String automatedTestReference;

        TestCasePatch() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getReference() {
            return this.reference;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getImportance() {
            return this.importance;
        }

        public void setImportance(String importance) {
            this.importance = importance;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Long getNature() {
            return this.nature;
        }

        public void setNature(Long nature) {
            this.nature = nature;
        }

        public Long getType() {
            return this.type;
        }

        public void setType(Long type) {
            this.type = type;
        }

        public String getPrerequisite() {
            return this.prerequisite;
        }

        public void setPrerequisite(String prerequisite) {
            this.prerequisite = prerequisite;
        }

        public boolean isImportanceAuto() {
            return this.importanceAuto;
        }

        public void setImportanceAuto(boolean importanceAuto) {
            this.importanceAuto = importanceAuto;
        }

        public String getAutomatable() {
            return this.automatable;
        }

        public void setAutomatable(String automatable) {
            this.automatable = automatable;
        }

        public Long getScmRepositoryId() {
            return this.scmRepositoryId;
        }

        public void setScmRepositoryId(Long scmRepositoryId) {
            this.scmRepositoryId = scmRepositoryId;
        }

        public Long getAutomatedTestTechnology() {
            return this.automatedTestTechnology;
        }

        public void setAutomatedTestTechnology(Long automatedTestTechnology) {
            this.automatedTestTechnology = automatedTestTechnology;
        }

        public String getAutomatedTestReference() {
            return this.automatedTestReference;
        }

        public void setAutomatedTestReference(String automatedTestReference) {
            this.automatedTestReference = automatedTestReference;
        }
    }
}

