/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;

@RestController
@RequestMapping(value={"backend/search/milestones"})
public class SearchMilestoneModificationController {
    private final TestCaseModificationService testCaseModificationService;
    private final RequirementVersionManagerService requirementVersionManagerService;

    public SearchMilestoneModificationController(TestCaseModificationService testCaseModificationService, RequirementVersionManagerService requirementVersionManagerService) {
        this.testCaseModificationService = testCaseModificationService;
        this.requirementVersionManagerService = requirementVersionManagerService;
    }

    @GetMapping(value={"test-case/{testCaseIds}"})
    public MilestoneMassEdit getMilestoneMassEditForTc(@PathVariable List<Long> testCaseIds) {
        MilestoneMassEdit data = new MilestoneMassEdit();
        data.setCheckedIds(this.testCaseModificationService.findBindedMilestonesIdForMassModif(testCaseIds));
        Collection milestones = this.testCaseModificationService.findAssociableMilestonesForMassModif(testCaseIds);
        data.setMilestoneIds(milestones.stream().map(Milestone::getId).collect(Collectors.toCollection(ArrayList::new)));
        data.setSamePerimeter(this.testCaseModificationService.haveSamePerimeter(testCaseIds));
        return data;
    }

    @PostMapping(value={"test-case"})
    public void bindMilestonesToTcs(@RequestBody MilestonesPatch milestonesPatch) {
        Collection bindedBefore = this.testCaseModificationService.findBindedMilestonesIdForMassModif(milestonesPatch.getBindableObjectIds());
        bindedBefore.removeAll(milestonesPatch.getMilestoneIds());
        for (Long testCaseId : milestonesPatch.getBindableObjectIds()) {
            this.testCaseModificationService.bindMilestones(testCaseId.longValue(), milestonesPatch.getMilestoneIds());
            this.testCaseModificationService.unbindMilestones(testCaseId.longValue(), bindedBefore);
        }
    }

    @GetMapping(value={"requirement/{requirementVersionIds}"})
    public MilestoneMassEdit getMilestoneMassEditForRequirement(@PathVariable List<Long> requirementVersionIds) {
        MilestoneMassEdit data = new MilestoneMassEdit();
        data.setCheckedIds(this.requirementVersionManagerService.findBindedMilestonesIdForMassModif(requirementVersionIds));
        Collection milestones = this.requirementVersionManagerService.findAssociableMilestonesForMassModif(requirementVersionIds);
        data.setMilestoneIds(milestones.stream().map(Milestone::getId).collect(Collectors.toCollection(ArrayList::new)));
        data.setSamePerimeter(this.requirementVersionManagerService.haveSamePerimeter(requirementVersionIds));
        return data;
    }

    @PostMapping(value={"requirement"})
    public boolean bindMilestonesToReqVersions(@RequestBody MilestonesPatch milestonesPatch) {
        List<Long> reqVersionIds = milestonesPatch.getBindableObjectIds();
        List<Long> milestoneIds = milestonesPatch.getMilestoneIds();
        Collection bindedBefore = this.requirementVersionManagerService.findBindedMilestonesIdForMassModif(reqVersionIds);
        bindedBefore.removeAll(milestoneIds);
        boolean isOneVersionAlreadyBound = !milestoneIds.isEmpty() && this.requirementVersionManagerService.isOneMilestoneAlreadyBindToAnotherRequirementVersion(reqVersionIds, milestoneIds);
        for (Long reqVersionId : reqVersionIds) {
            this.requirementVersionManagerService.bindMilestones(reqVersionId.longValue(), milestoneIds);
            this.requirementVersionManagerService.unbindMilestones(reqVersionId.longValue(), bindedBefore);
        }
        return isOneVersionAlreadyBound;
    }

    private static class MilestoneMassEdit {
        private Collection<Long> checkedIds = new ArrayList<Long>();
        private Collection<Long> milestoneIds = new ArrayList<Long>();
        private boolean samePerimeter;

        private MilestoneMassEdit() {
        }

        public Collection<Long> getCheckedIds() {
            return this.checkedIds;
        }

        public void setCheckedIds(Collection<Long> checkedIds) {
            this.checkedIds = checkedIds;
        }

        public Collection<Long> getMilestoneIds() {
            return this.milestoneIds;
        }

        public void setMilestoneIds(Collection<Long> milestoneIds) {
            this.milestoneIds = milestoneIds;
        }

        public boolean isSamePerimeter() {
            return this.samePerimeter;
        }

        public void setSamePerimeter(boolean samePerimeter) {
            this.samePerimeter = samePerimeter;
        }
    }

    private static class MilestonesPatch {
        private List<Long> milestoneIds = new ArrayList<Long>();
        private List<Long> bindableObjectIds = new ArrayList<Long>();

        private MilestonesPatch() {
        }

        public List<Long> getMilestoneIds() {
            return this.milestoneIds;
        }

        public void setMilestoneIds(List<Long> milestoneIds) {
            this.milestoneIds = milestoneIds;
        }

        public List<Long> getBindableObjectIds() {
            return this.bindableObjectIds;
        }

        public void setBindableObjectIds(List<Long> bindableObjectIds) {
            this.bindableObjectIds = bindableObjectIds;
        }
    }
}

