/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.scm.server;

import jakarta.inject.Inject;
import java.util.List;
import org.apache.commons.collections4.map.SingletonMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.scm.server.ScmServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.ScmServerAdminViewDto;
import org.squashtest.tm.service.scmserver.ScmServerManagerService;

@RestController
@RequestMapping(value={"/backend/scm-server-view"})
public class ScmServerViewController {
    private final ScmServerDisplayService scmServerDisplayService;
    private final ScmServerManagerService scmServerManagerService;

    @Inject
    ScmServerViewController(ScmServerDisplayService scmServerDisplayService, ScmServerManagerService scmServerManagerService) {
        this.scmServerDisplayService = scmServerDisplayService;
        this.scmServerManagerService = scmServerManagerService;
    }

    @GetMapping(value={"/{scmServerId}"})
    public ScmServerAdminViewDto getScmServerView(@PathVariable long scmServerId) {
        return this.scmServerDisplayService.getScmServerView(scmServerId);
    }

    @GetMapping(value={"/{scmServerIds}/are-used-by-test-cases"})
    public SingletonMap<String, Boolean> areScmServersUsed(@PathVariable List<Long> scmServerIds) {
        boolean areUsed = this.scmServerManagerService.areServerRepositoriesBoundToProjectOrTestCases(scmServerIds);
        return new SingletonMap((Object)"areUsed", (Object)areUsed);
    }
}

