/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.requirement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.NodeWorkspace;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.requirement.NewRequirementVersionDto;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.exception.library.RightsUnsuficientsForOperationException;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.display.workspace.tree.MultipleHierarchyTreeBrowser;
import org.squashtest.tm.service.display.workspace.tree.TreeBrowser;
import org.squashtest.tm.service.display.workspace.tree.TreeNodeCollectorService;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.library.LibraryNavigationService;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.requirement.RequirementStatisticsService;
import org.squashtest.tm.web.backend.controller.form.model.EntityFormModel;
import org.squashtest.tm.web.backend.controller.form.model.EntityFormModelValidator;
import org.squashtest.tm.web.backend.controller.form.model.IdList;
import org.squashtest.tm.web.backend.controller.form.model.NodeList;
import org.squashtest.tm.web.backend.controller.form.model.NodeListAndWhiteList;
import org.squashtest.tm.web.backend.controller.form.model.RequirementFolderFormModel;
import org.squashtest.tm.web.backend.controller.form.model.RequirementFormModel;
import org.squashtest.tm.web.backend.controller.navigation.AbstractLibraryNavigationController;

@RestController
@RequestMapping(path={"backend/requirement-tree"})
public class RequirementLibraryNavigationController
extends AbstractLibraryNavigationController<RequirementLibrary, RequirementFolder, RequirementLibraryNode> {
    private static final String ADD_REQUIREMENT_FOLDER = "add-requirement-folder";
    private static final String ADD_REQUIREMENT = "add-requirement";
    private final RequirementLibraryNavigationService requirementLibraryNavigationService;
    private final TreeNodeCollectorService treeNodeCollectorService;
    private final ActiveMilestoneHolder activeMilestoneHolder;
    private final RequirementStatisticsService requirementStatisticsService;

    public RequirementLibraryNavigationController(MultipleHierarchyTreeBrowser treeBrowser, RequirementLibraryNavigationService requirementLibraryNavigationService, TreeNodeCollectorService treeNodeCollectorService, MessageSource messageSource, ActiveMilestoneHolder activeMilestoneHolder, RequirementStatisticsService requirementStatisticsService) {
        super((TreeBrowser)treeBrowser, messageSource);
        this.requirementLibraryNavigationService = requirementLibraryNavigationService;
        this.treeNodeCollectorService = treeNodeCollectorService;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.requirementStatisticsService = requirementStatisticsService;
    }

    @PostMapping(value={"/{destinationId}/content/paste"})
    public void copyNodes(@RequestBody NodeListAndWhiteList nodeListAndWhiteList, @PathVariable(value="destinationId") String destinationId) {
        NodeReference nodeReference = NodeReference.fromNodeId((String)destinationId);
        List<Long> copiedNodeIds = nodeListAndWhiteList.getIds();
        ClipboardPayload clipboardPayload = nodeListAndWhiteList.asClipboardPayload();
        try {
            switch (nodeReference.getNodeType()) {
                case REQUIREMENT_FOLDER: {
                    this.requirementLibraryNavigationService.copyNodesToFolder(nodeReference.getId().longValue(), copiedNodeIds.toArray(new Long[0]), clipboardPayload);
                    break;
                }
                case REQUIREMENT_LIBRARY: {
                    this.requirementLibraryNavigationService.copyNodesToLibrary(nodeReference.getId().longValue(), copiedNodeIds.toArray(new Long[0]), clipboardPayload);
                    break;
                }
                case REQUIREMENT: 
                case HIGH_LEVEL_REQUIREMENT: {
                    this.requirementLibraryNavigationService.copyNodesToRequirement(nodeReference.getId().longValue(), copiedNodeIds.toArray(new Long[0]), clipboardPayload);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("copy nodes : specified destination type doesn't exists : " + String.valueOf(nodeReference.getNodeType()));
                }
            }
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @PostMapping(value={"/{destinationRef}/content/move"})
    public void moveNodes(@RequestBody NodeList nodeList, @PathVariable(value="destinationRef") String destinationRef) {
        NodeReference nodeReference = NodeReference.fromNodeId((String)destinationRef);
        Long destinationId = nodeReference.getId();
        NodeType destinationType = nodeReference.getNodeType();
        Long[] movedNodeIds = nodeList.getIds().toArray(new Long[0]);
        ClipboardPayload clipboardPayload = ClipboardPayload.withWhiteListIgnored(nodeList.getIds());
        try {
            switch (destinationType) {
                case REQUIREMENT_LIBRARY: {
                    this.requirementLibraryNavigationService.moveNodesToLibrary(destinationId.longValue(), movedNodeIds, clipboardPayload);
                    break;
                }
                case REQUIREMENT_FOLDER: {
                    this.requirementLibraryNavigationService.moveNodesToFolder(destinationId.longValue(), movedNodeIds, clipboardPayload);
                    break;
                }
                case REQUIREMENT: 
                case HIGH_LEVEL_REQUIREMENT: {
                    this.requirementLibraryNavigationService.moveNodesToRequirement(destinationId.longValue(), movedNodeIds, clipboardPayload);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("move nodes : specified destination type doesn't exists : " + String.valueOf(destinationType));
                }
            }
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @PostMapping(value={"/{destinationRef}/content/move/{position}"})
    public void moveNodesAtPosition(@RequestBody NodeList nodeList, @PathVariable(value="destinationRef") String destinationRef, @PathVariable(value="position") int position) {
        NodeReference nodeReference = NodeReference.fromNodeId((String)destinationRef);
        Long destinationId = nodeReference.getId();
        NodeType destinationType = nodeReference.getNodeType();
        Long[] movedNodeIds = nodeList.getIds().toArray(new Long[0]);
        ClipboardPayload clipboardPayload = ClipboardPayload.withWhiteListIgnored(nodeList.getIds());
        try {
            switch (destinationType) {
                case REQUIREMENT_LIBRARY: {
                    this.requirementLibraryNavigationService.moveNodesToLibrary(destinationId.longValue(), movedNodeIds, position, clipboardPayload);
                    break;
                }
                case REQUIREMENT_FOLDER: {
                    this.requirementLibraryNavigationService.moveNodesToFolder(destinationId.longValue(), movedNodeIds, position, clipboardPayload);
                    break;
                }
                case REQUIREMENT: 
                case HIGH_LEVEL_REQUIREMENT: {
                    this.requirementLibraryNavigationService.moveNodesToRequirement(destinationId.longValue(), movedNodeIds, position, clipboardPayload);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("move nodes : specified destination type doesn't exists : " + String.valueOf(destinationType));
                }
            }
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"new-folder"}, consumes={"application/json"}, produces={"application/json"})
    public DataRow addNewFolder(@RequestBody RequirementFolderFormModel folderModel) throws BindException {
        this.validateRequirementFolderFormModel(folderModel);
        RequirementFolder requirementFolder = folderModel.getRequirementFolder();
        EntityReference parentEntityReference = this.getParentNodeReference(folderModel);
        this.createAndPersistRequirementFolder(requirementFolder, parentEntityReference, folderModel.getCufs());
        return this.treeNodeCollectorService.collectNode(NodeType.REQUIREMENT_FOLDER, (Identified)requirementFolder);
    }

    private void createAndPersistRequirementFolder(RequirementFolder requirementFolder, EntityReference parentEntityReference, Map<Long, RawValue> cufs) {
        switch (parentEntityReference.getType()) {
            case REQUIREMENT_LIBRARY: {
                this.requirementLibraryNavigationService.addFolderToLibrary(parentEntityReference.getId().longValue(), (Folder)requirementFolder, cufs);
                break;
            }
            case REQUIREMENT_FOLDER: {
                this.requirementLibraryNavigationService.addFolderToFolder(parentEntityReference.getId().longValue(), (Folder)requirementFolder, cufs);
                break;
            }
            default: {
                throw new IllegalArgumentException("This entity type is not handled " + parentEntityReference.toNodeId());
            }
        }
    }

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"new-requirement"})
    public DataRow addNewRequirement(@RequestBody RequirementFormModel requirementModel) throws BindException {
        this.validateRequirementFormModel(requirementModel);
        EntityReference parentEntityReference = this.getParentNodeReference(requirementModel);
        Requirement req = this.createAndPersistRequirement(parentEntityReference, requirementModel.toDTO());
        return this.treeNodeCollectorService.collectNode(NodeType.REQUIREMENT, (Identified)req);
    }

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"new-high-level-requirement"})
    public DataRow addNewHighLevelRequirement(@RequestBody RequirementFormModel requirementModel) throws BindException {
        this.validateRequirementFormModel(requirementModel);
        EntityReference parentEntityReference = this.getParentNodeReference(requirementModel);
        Requirement req = this.createAndPersistRequirement(parentEntityReference, (NewRequirementVersionDto)requirementModel.toHighLevelDTO());
        return this.treeNodeCollectorService.collectNode(NodeType.HIGH_LEVEL_REQUIREMENT, (Identified)req);
    }

    private EntityReference getParentNodeReference(EntityFormModel entityFormModel) {
        String serializedParentEntityReference = entityFormModel.getParentEntityReference();
        return EntityReference.fromNodeId((String)serializedParentEntityReference);
    }

    private Requirement createAndPersistRequirement(EntityReference parentEntityReference, NewRequirementVersionDto newRequirementVersionDto) {
        return switch (parentEntityReference.getType()) {
            case EntityType.REQUIREMENT_LIBRARY -> this.requirementLibraryNavigationService.addRequirementToRequirementLibrary(parentEntityReference.getId().longValue(), newRequirementVersionDto, this.activeMilestoneAsList());
            case EntityType.REQUIREMENT_FOLDER -> this.requirementLibraryNavigationService.addRequirementToRequirementFolder(parentEntityReference.getId().longValue(), newRequirementVersionDto, this.activeMilestoneAsList());
            case EntityType.REQUIREMENT -> this.requirementLibraryNavigationService.addRequirementToRequirement(parentEntityReference.getId().longValue(), newRequirementVersionDto, this.activeMilestoneAsList());
            case EntityType.HIGH_LEVEL_REQUIREMENT -> this.requirementLibraryNavigationService.addRequirementToHighLevelRequirement(parentEntityReference.getId().longValue(), newRequirementVersionDto, this.activeMilestoneAsList());
            default -> throw new IllegalArgumentException("This entity type is not handled " + parentEntityReference.toNodeId());
        };
    }

    @PostMapping(value={"/validation-statistics"})
    public IdList getValidationRequirementIds(@RequestBody ValidationStatisticRequest validationStatisticRequest) {
        Collection ids = this.activeMilestoneAsList().isEmpty() ? this.requirementStatisticsService.gatherRequirementIdsFromValidation(validationStatisticRequest.selectedIds, RequirementCriticality.valueOf((String)validationStatisticRequest.criticality), validationStatisticRequest.validation) : this.requirementStatisticsService.gatherRequirementIdsFromValidationByVersionIds(validationStatisticRequest.selectedIds, RequirementCriticality.valueOf((String)validationStatisticRequest.criticality), validationStatisticRequest.validation);
        return new IdList(ids);
    }

    private void validateRequirementFormModel(RequirementFormModel requirementModel) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)requirementModel, ADD_REQUIREMENT);
        RequirementFormModel.RequirementFormModelValidator validator = new RequirementFormModel.RequirementFormModelValidator(this.messageSource);
        validator.validate(requirementModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
    }

    private List<Long> activeMilestoneAsList() {
        ArrayList<Long> milestoneIds = new ArrayList<Long>();
        Optional activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        activeMilestone.ifPresent(milestone -> {
            boolean bl = milestoneIds.add(milestone.getId());
        });
        return milestoneIds;
    }

    @Override
    protected LibraryNavigationService<RequirementLibrary, RequirementFolder, RequirementLibraryNode> getLibraryNavigationService() {
        return this.requirementLibraryNavigationService;
    }

    @Override
    protected NodeWorkspace getWorkspace() {
        return NodeWorkspace.REQUIREMENT;
    }

    private void validateRequirementFolderFormModel(RequirementFolderFormModel folderModel) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)folderModel, ADD_REQUIREMENT_FOLDER);
        EntityFormModelValidator entityFormModelValidator = new EntityFormModelValidator();
        entityFormModelValidator.validate(folderModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
    }

    static class ValidationStatisticRequest {
        private List<Long> selectedIds;
        private String criticality;
        private Collection<String> validation;

        ValidationStatisticRequest() {
        }

        public List<Long> getSelectedIds() {
            return this.selectedIds;
        }

        public void setSelectedIds(List<Long> selectedIds) {
            this.selectedIds = selectedIds;
        }

        public String getCriticality() {
            return this.criticality;
        }

        public void setCriticality(String criticality) {
            this.criticality = criticality;
        }

        public Collection<String> getValidation() {
            return this.validation;
        }

        public void setValidation(Collection<String> validation) {
            this.validation = validation;
        }
    }
}

