/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.report;

import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.report.ReportModificationService;
import org.squashtest.tm.web.backend.controller.form.model.CreatedEntityId;
import org.squashtest.tm.web.backend.controller.report.ReportData;
import org.squashtest.tm.web.backend.report.IdentifiedReportDecorator;
import org.squashtest.tm.web.backend.report.ReportsRegistry;

@RestController
@RequestMapping(value={"backend/report-workbench"})
public class ReportWorkbenchController {
    private final ReportsRegistry reportsRegistry;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    private final ReportModificationService reportModificationService;

    public ReportWorkbenchController(ReportsRegistry reportsRegistry, CustomReportLibraryNodeService customReportLibraryNodeService, ReportModificationService reportModificationService) {
        this.reportsRegistry = reportsRegistry;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.reportModificationService = reportModificationService;
    }

    @GetMapping(value={"/{customReportLibraryNodeId}"})
    public ReportWorkbenchData getAvailableReports(@PathVariable Long customReportLibraryNodeId) {
        CustomReportLibraryNode node = this.customReportLibraryNodeService.findCustomReportLibraryNodeById(customReportLibraryNodeId);
        Long projectId = node.getLibrary().getProject().getId();
        if (node.getEntityType().getTypeName().equals("REPORT")) {
            ReportDefinition reportDefinition = (ReportDefinition)node.getEntity();
            ReportWorkbenchReportDefinition def = new ReportWorkbenchReportDefinition(reportDefinition);
            return new ReportWorkbenchData(this.reportsRegistry.getSortedReports(), projectId, def);
        }
        return new ReportWorkbenchData(this.reportsRegistry.getSortedReports(), projectId);
    }

    @PostMapping(value={"/new/{parentId}"})
    public CreatedEntityId saveReport(@RequestBody ReportDefinition reportDefinition, @PathVariable(value="parentId") Long parentId) {
        CustomReportLibraryNode node = this.customReportLibraryNodeService.createNewNode(parentId, (CustomReportTreeEntity)reportDefinition);
        return new CreatedEntityId(node.getId());
    }

    @PostMapping(value={"/update/{parentId}"})
    public CreatedEntityId updateReportDefinition(@RequestBody ReportDefinition definition, @PathVariable(value="parentId") long parentId) {
        ReportDefinition oldDef = this.customReportLibraryNodeService.findReportDefinitionByNodeId(Long.valueOf(parentId));
        definition.setId(oldDef.getId());
        this.reportModificationService.updateDefinition(definition, oldDef);
        return new CreatedEntityId(parentId);
    }

    static class ReportWorkbenchData {
        private final List<ReportData> availableReports;
        private final Long projectId;
        private final ReportWorkbenchReportDefinition reportDefinition;

        ReportWorkbenchData(List<IdentifiedReportDecorator> availableReports, Long projectId) {
            this(availableReports, projectId, null);
        }

        public ReportWorkbenchData(List<IdentifiedReportDecorator> availableReports, Long projectId, ReportWorkbenchReportDefinition reportDefinition) {
            this.availableReports = availableReports.stream().map(ReportData::new).toList();
            this.reportDefinition = reportDefinition;
            this.projectId = projectId;
        }

        public List<ReportData> getAvailableReports() {
            return this.availableReports;
        }

        public Long getProjectId() {
            return this.projectId;
        }

        public ReportWorkbenchReportDefinition getReportDefinition() {
            return this.reportDefinition;
        }
    }

    static class ReportWorkbenchReportDefinition {
        private final Long id;
        private final String name;
        private final String description;
        private final String summary;
        private final String pluginNamespace;
        private final String parameters;

        public ReportWorkbenchReportDefinition(ReportDefinition definition) {
            this.id = definition.getId();
            this.name = definition.getName();
            this.description = definition.getDescription();
            this.summary = definition.getSummary();
            this.pluginNamespace = definition.getPluginNamespace();
            this.parameters = definition.getParameters();
        }

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getPluginNamespace() {
            return this.pluginNamespace;
        }

        public String getParameters() {
            return this.parameters;
        }
    }
}

