/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.report;

import org.squashtest.tm.api.report.form.BasicInput;
import org.squashtest.tm.api.report.form.CheckboxInput;
import org.squashtest.tm.api.report.form.Input;
import org.squashtest.tm.api.report.form.InputType;
import org.squashtest.tm.api.report.form.InputVisitor;
import org.squashtest.tm.api.report.form.InputsGroup;
import org.squashtest.tm.api.report.form.LabelInput;
import org.squashtest.tm.api.report.form.OptionsGroup;
import org.squashtest.tm.api.report.form.TemplateDropdownList;
import org.squashtest.tm.api.report.form.TextInput;
import org.squashtest.tm.api.report.form.TreePicker;
import org.squashtest.tm.web.backend.controller.report.InputJson;
import org.squashtest.tm.web.backend.controller.report.InputsGroupJson;
import org.squashtest.tm.web.backend.controller.report.OptionInputJson;
import org.squashtest.tm.web.backend.controller.report.OptionsGroupJson;
import org.squashtest.tm.web.backend.controller.report.TemplateDropdownListJson;
import org.squashtest.tm.web.backend.controller.report.TreePickerJson;

class BasicInputJson
implements InputJson {
    private final String name;
    private final InputType type;
    private final String disabledBy;
    private final String label;
    private final boolean required;

    public BasicInputJson(BasicInput input) {
        this.name = input.getName();
        this.type = input.getType();
        this.disabledBy = input.getDisabledBy();
        this.label = input.getLabel();
        this.required = input.isRequired();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public InputType getType() {
        return this.type;
    }

    public String getDisabledBy() {
        return this.disabledBy;
    }

    public static InputJson fromInput(Input input) {
        final InputJson[] basicInputJsons = new InputJson[1];
        InputVisitor inputVisitor = new InputVisitor(){

            public void visit(TemplateDropdownList templateDropdownList) {
                basicInputJsons[0] = new TemplateDropdownListJson(templateDropdownList);
            }

            public void visit(OptionsGroup optionsGroup) {
                basicInputJsons[0] = new OptionsGroupJson(optionsGroup);
            }

            public void visit(InputsGroup inputsGroup) {
                basicInputJsons[0] = new InputsGroupJson(inputsGroup);
            }

            public void visit(CheckboxInput checkboxInput) {
                basicInputJsons[0] = new OptionInputJson.CheckBoxInputJson(checkboxInput);
            }

            public void visit(TreePicker treePicker) {
                basicInputJsons[0] = new TreePickerJson(treePicker);
            }

            public void visit(LabelInput labelInput) {
                basicInputJsons[0] = new BasicInputJson((BasicInput)labelInput);
            }

            public void visit(TextInput textInput) {
                basicInputJsons[0] = new BasicInputJson((BasicInput)textInput);
            }
        };
        input.accept(inputVisitor);
        return basicInputJsons[0];
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isRequired() {
        return this.required;
    }
}

