/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.project;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.service.display.project.ProjectDisplayService;
import org.squashtest.tm.service.internal.display.dto.BindMilestoneToProjectDialogData;
import org.squashtest.tm.service.internal.display.dto.PivotFormatImportDto;
import org.squashtest.tm.service.internal.display.dto.ProjectViewDto;
import org.squashtest.tm.service.internal.display.dto.TestAutomationProjectDto;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.project.ProjectManagerService;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.testautomation.TestAutomationServerCredentialsService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.web.backend.manager.plugin.ConfigurablePluginManager;

@RestController
@RequestMapping(value={"/backend/project-view"})
public class ProjectViewController {
    private final ProjectDisplayService projectViewDisplayService;
    private final GenericProjectManagerService genericProjectManagerService;
    private final ProjectManagerService projectManagerService;
    private final ConfigurablePluginManager pluginManager;
    private final UserAccountService userAccountService;
    private final TestAutomationServerCredentialsService testAutomationServerCredentialsService;

    @Inject
    ProjectViewController(ProjectDisplayService projectViewDisplayService, GenericProjectManagerService projectManager, ProjectManagerService projectManagerService, ConfigurablePluginManager pluginManager, UserAccountService userAccountService, TestAutomationServerCredentialsService testAutomationServerCredentialsService) {
        this.projectViewDisplayService = projectViewDisplayService;
        this.genericProjectManagerService = projectManager;
        this.projectManagerService = projectManagerService;
        this.pluginManager = pluginManager;
        this.userAccountService = userAccountService;
        this.testAutomationServerCredentialsService = testAutomationServerCredentialsService;
    }

    @GetMapping(value={"/{projectId}"})
    public ProjectViewDto getProjectView(@PathVariable long projectId) {
        ProjectViewDto dto = this.projectViewDisplayService.getProjectView(projectId);
        dto.setAvailablePlugins(this.pluginManager.getAvailablePlugins(projectId));
        if (Boolean.TRUE.equals(dto.getAllowAutomationWorkflow()) && "REMOTE_WORKFLOW".equals(dto.getAutomationWorkflowType()) && !this.projectViewDisplayService.checkRemotePluginIsAvailableInProject(dto)) {
            this.genericProjectManagerService.changeAutomationWorkflow(dto.getId().longValue(), "NONE");
            dto.setAutomationWorkflowType("NONE");
        }
        return dto;
    }

    @GetMapping(value={"/{projectId}/statuses-in-use"})
    public Map<String, Boolean> getProjectStatusesInUse(@PathVariable long projectId) {
        return this.projectViewDisplayService.getProjectStatusesInUse(projectId);
    }

    @GetMapping(value={"/{projectId}/available-milestones"})
    public BindMilestoneToProjectDialogData getAvailableMilestones(@PathVariable long projectId) {
        return this.projectViewDisplayService.findAvailableMilestones(projectId);
    }

    @GetMapping(value={"/{projectId}/available-ta-projects"})
    public Map<String, List<TestAutomationProjectDto>> getAvailableTAProjects(@PathVariable long projectId) {
        List<TestAutomationProjectDto> dtos = this.genericProjectManagerService.findAllAvailableTaProjects(projectId).stream().map(taProject -> TestAutomationProjectDto.fromRemoteTestAutomationProject((TestAutomationProject)taProject, (Long)projectId)).toList();
        return Collections.singletonMap("taProjects", dtos);
    }

    @PostMapping(value={"/test-automation-server/{serverId}/authentication"})
    public void authenticate(@RequestBody ManageableCredentials credentials, @PathVariable(value="serverId") long serverId) {
        this.testAutomationServerCredentialsService.validateCredentials(serverId, credentials);
        this.userAccountService.saveCurrentUserCredentials(serverId, credentials);
    }

    @GetMapping(value={"/{projectId}/restricted-ta-projects"})
    public Map<String, List<TestAutomationProjectDto>> getAvailableTAProjectsForCurrentUser(@PathVariable long projectId) {
        List<TestAutomationProjectDto> dtos = this.genericProjectManagerService.findAllAvailableTaProjectsWithUserLevelCredentials(projectId).stream().map(taProject -> TestAutomationProjectDto.fromRemoteTestAutomationProject((TestAutomationProject)taProject, (Long)projectId)).toList();
        return Collections.singletonMap("taProjects", dtos);
    }

    @GetMapping(value={"/{projectId}/bugtracker/projectNames"})
    public Map<String, Object> getBugtrackerProjectNames(@PathVariable long projectId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        List bugtrackerProjectNames = this.projectViewDisplayService.fetchBugtrackerProjectNames(projectId);
        if (!bugtrackerProjectNames.isEmpty()) {
            response.put("projectNames", bugtrackerProjectNames);
        }
        return response;
    }

    @PostMapping(value={"/{projectId}/bugtracker/projectNames"})
    public Map<String, Object> updateBugtrackerProjectNames(@RequestBody List<String> projectBugTrackerNames, @PathVariable long projectId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        this.projectManagerService.updateBugTrackerProjectNames(projectId, projectBugTrackerNames);
        response.put("projectNames", projectBugTrackerNames);
        return response;
    }

    @GetMapping(value={"/{projectId}/refresh-project-imports"})
    public List<PivotFormatImportDto> refreshProjectImports(@PathVariable long projectId) {
        return this.projectViewDisplayService.getExistingImports(projectId);
    }
}

